/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.rule;

import java.util.LinkedHashSet;
import java.util.Set;
import org.ocpsoft.rewrite.config.Direction;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.Path;
import org.ocpsoft.rewrite.servlet.config.Substitute;
import org.ocpsoft.rewrite.servlet.config.rule.CDNRelocate;

public class CDN
implements Rule,
CDNRelocate,
Parameterized {
    private String id;
    private Substitute location;
    private final Path resource;

    protected CDN(String pattern) {
        this.resource = Path.matches(pattern);
    }

    public static CDNRelocate relocate(String pattern) {
        return new CDN(pattern);
    }

    @Override
    public CDN to(String location) {
        this.location = Substitute.with(location);
        return this;
    }

    public boolean evaluate(Rewrite event, EvaluationContext context) {
        if (Direction.isOutbound().evaluate(event, context)) {
            return this.resource.evaluate(event, context);
        }
        return false;
    }

    public void perform(Rewrite event, EvaluationContext context) {
        if (Direction.isOutbound().evaluate(event, context)) {
            this.location.perform(event, context);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return "Join [resource=" + (Object)((Object)this.resource) + ", to=" + (Object)((Object)this.location) + ", id=" + this.id + "]";
    }

    public ParameterizedPatternParser getLocationExpression() {
        return this.location.getExpression();
    }

    public ParameterizedPatternParser getResourcExpression() {
        return this.resource.getExpression();
    }

    public Set<String> getRequiredParameterNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(this.resource.getRequiredParameterNames());
        result.addAll(this.location.getRequiredParameterNames());
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        this.resource.setParameterStore(store);
        this.location.setParameterStore(store);
    }
}

