/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.LinkedHashSet;
import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ConfigurableParameter;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexConstraint;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.bind.RequestBinding;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;
import org.ocpsoft.urlbuilder.Address;

public abstract class PathAndQuery
extends HttpCondition
implements Parameterized {
    private final ParameterizedPatternParser expression;
    private boolean withRequestBinding = false;
    private String captureIn;

    private PathAndQuery(String pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null.");
        this.expression = new RegexParameterizedPatternParser(".+", pattern);
    }

    public static PathAndQuery matches(final String pattern) {
        return new PathAndQuery(pattern){

            public String toString() {
                return "PathAndQuery.matches(\"" + pattern + "\")";
            }
        };
    }

    public static PathAndQuery captureIn(final String param) {
        PathAndQuery path = new PathAndQuery("{" + param + "}"){

            public String toString() {
                return "PathAndQuery.captureIn(\"" + param + "\")";
            }
        };
        path.captureIn = param;
        return path;
    }

    public PathAndQuery withRequestBinding() {
        this.withRequestBinding = true;
        return this;
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String url = null;
        if (event instanceof HttpOutboundServletRewrite) {
            url = ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).getPathAndQuery();
            if (url == null) {
                return false;
            }
        } else {
            url = URLBuilder.createFrom((String)event.getInboundAddress().getPathAndQuery()).decode().toURL();
        }
        if (url.startsWith(event.getContextPath())) {
            url = url.substring(event.getContextPath().length());
        }
        return this.expression.matches((Rewrite)event, context, url);
    }

    public ParameterizedPatternParser getExpression() {
        return this.expression;
    }

    public Set<String> getRequiredParameterNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.captureIn != null) {
            result.add(this.captureIn);
        } else {
            result.addAll(this.expression.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        Parameter parameter;
        if (this.captureIn != null && (parameter = store.get(this.captureIn)) instanceof ConfigurableParameter) {
            ((ConfigurableParameter)parameter).constrainedBy((Constraint)new RegexConstraint(".*"));
        }
        if (this.withRequestBinding) {
            for (String param : this.getRequiredParameterNames()) {
                Parameter parameter2 = store.get(param);
                if (!(parameter2 instanceof ConfigurableParameter)) continue;
                ((ConfigurableParameter)parameter2).bindsTo((Binding)RequestBinding.parameter(param));
            }
            this.withRequestBinding = true;
        }
        this.expression.setParameterStore(store);
    }
}

