/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.rule;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.ConditionVisit;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.ParameterizedCallback;
import org.ocpsoft.rewrite.config.ParameterizedConditionVisitor;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.servlet.config.DispatchType;
import org.ocpsoft.rewrite.servlet.config.Forward;
import org.ocpsoft.rewrite.servlet.config.Path;
import org.ocpsoft.rewrite.servlet.config.Query;
import org.ocpsoft.rewrite.servlet.config.Redirect;
import org.ocpsoft.rewrite.servlet.config.Substitute;
import org.ocpsoft.rewrite.servlet.config.rule.JoinPath;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.QueryStringBuilder;
import org.ocpsoft.rewrite.util.Visitor;
import org.ocpsoft.urlbuilder.Address;

public class Join
implements Rule,
JoinPath,
Parameterized {
    private static final String JOIN_DISABLED_KEY = Join.class.getName() + "_DISABLED";
    private static final String CURRENT_JOIN = Join.class.getName() + "_current";
    private String id;
    private final String requestPattern;
    private String resourcePattern;
    private final Path requestPath;
    private Path resourcePath;
    private boolean inboundCorrection = false;
    private boolean chainingDisabled = true;
    private boolean bindingEnabled = true;
    private Set<String> pathRequestParameters;
    private ConditionBuilder outboundConditionCache;
    private ParameterStore store;

    protected Join(String pattern, boolean requestBinding) {
        this.requestPattern = pattern;
        this.requestPath = Path.matches(pattern);
        if (requestBinding) {
            this.requestPath.withRequestBinding();
        }
        this.bindingEnabled = requestBinding;
    }

    public static JoinPath path(String pattern) {
        return new Join(pattern, true);
    }

    public static JoinPath pathNonBinding(String pattern) {
        return new Join(pattern, false);
    }

    public static Join getCurrentJoin(HttpServletRequest request) {
        return (Join)request.getAttribute(CURRENT_JOIN);
    }

    @Override
    public Join to(String resource) {
        if (this.resourcePattern != null) {
            throw new IllegalStateException("Cannot set resource path more than once.");
        }
        this.resourcePattern = resource;
        this.resourcePath = Path.matches(resource);
        Set<String> parameters = this.getPathRequestParameters();
        if (this.outboundConditionCache == null) {
            this.outboundConditionCache = this.resourcePath;
            for (String name : parameters) {
                Query parameter = Query.parameterExists(name);
                this.outboundConditionCache = this.outboundConditionCache.and((Condition)parameter);
            }
        }
        return this;
    }

    public Join withInboundCorrection() {
        this.inboundCorrection = true;
        return this;
    }

    public Join withChaining() {
        this.chainingDisabled = false;
        return this;
    }

    public boolean evaluate(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            if (!this.isChainingDisabled(event) && this.requestPath.evaluate(event, context)) {
                return true;
            }
            if (this.inboundCorrection && this.resourcePath.andNot((Condition)DispatchType.isForward()).evaluate(event, context)) {
                Set<String> parameters = this.getPathRequestParameters();
                for (String param : parameters) {
                    Query query = Query.parameterExists(param);
                    query.setParameterStore(this.store);
                    if (query.evaluate(event, context)) continue;
                    return false;
                }
                Redirect redirect = Redirect.permanent(((HttpInboundServletRewrite)event).getContextPath() + this.requestPattern);
                redirect.setParameterStore(this.store);
                context.addPreOperation((Operation)redirect);
                return true;
            }
        } else if (event instanceof HttpOutboundServletRewrite && this.outboundConditionCache.evaluate(event, context)) {
            return true;
        }
        return false;
    }

    private boolean isChainingDisabled(Rewrite event) {
        return Boolean.TRUE.equals(event.getRewriteContext().get((Object)JOIN_DISABLED_KEY));
    }

    private Set<String> getPathRequestParameters() {
        if (this.pathRequestParameters == null) {
            Set<String> nonQueryParameters = this.resourcePath.getRequiredParameterNames();
            Set<String> queryParameters = this.requestPath.getRequiredParameterNames();
            queryParameters.removeAll(nonQueryParameters);
            this.pathRequestParameters = queryParameters;
        }
        return this.pathRequestParameters;
    }

    public void perform(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            this.saveCurrentJoin((HttpServletRequest)((HttpInboundServletRewrite)event).getRequest());
            if (this.chainingDisabled) {
                event.getRewriteContext().put((Object)JOIN_DISABLED_KEY, (Object)true);
            }
            Forward forward = Forward.to(this.resourcePattern);
            forward.setParameterStore(this.store);
            forward.perform(event, context);
        } else if (event instanceof HttpOutboundServletRewrite) {
            Set<String> parameters = this.getPathRequestParameters();
            String outboundURL = ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).toString();
            QueryStringBuilder query = QueryStringBuilder.createNew();
            if (outboundURL.contains("?")) {
                query.addParameters(outboundURL);
                for (String string : parameters) {
                    List values = query.removeParameter(string);
                    if (values.size() <= 1) continue;
                    query.addParameter(string, values.subList(1, values.size()).toArray(new String[0]));
                }
            }
            Address outboundAddress = (Address)((HttpOutboundServletRewrite)event).getOutboundAddress();
            Substitute substitute = Substitute.with(this.requestPattern + query.toQueryString());
            substitute.setParameterStore(this.store);
            substitute.perform(event, context);
            Address rewrittenAddress = (Address)((HttpOutboundServletRewrite)event).getOutboundAddress();
            String rewrittenPath = rewrittenAddress.getPath();
            String contextPath = ((HttpServletRewrite)event).getContextPath();
            if (!contextPath.equals("/") && rewrittenPath.startsWith(contextPath)) {
                rewrittenPath = rewrittenPath.substring(contextPath.length());
            }
            if (!outboundAddress.equals(rewrittenAddress) && !this.requestPath.getExpression().parse(rewrittenPath).submit(event, context)) {
                ((HttpOutboundServletRewrite)event).setOutboundAddress(rewrittenAddress);
            } else if (this.chainingDisabled) {
                ((HttpOutboundServletRewrite)event).handled();
            }
        }
    }

    private void saveCurrentJoin(HttpServletRequest request) {
        request.setAttribute(CURRENT_JOIN, (Object)this);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        String result = "Join.";
        result = this.bindingEnabled ? result + "path" : result + "pathNonBinding";
        result = result + "(\"" + this.requestPattern + "\").to(\"" + this.resourcePattern + "\")";
        if (this.inboundCorrection) {
            result = result + ".withInboundCorrection()";
        }
        if (!this.chainingDisabled) {
            result = result + ".withChaning()";
        }
        return result;
    }

    public Set<String> getRequiredParameterNames() {
        final LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(this.requestPath.getRequiredParameterNames());
        result.addAll(this.resourcePath.getRequiredParameterNames());
        if (this.outboundConditionCache != null) {
            ParameterizedConditionVisitor visitor = new ParameterizedConditionVisitor(new ParameterizedCallback(){

                public void call(Parameterized parameterized) {
                    result.addAll(parameterized.getRequiredParameterNames());
                }
            });
            new ConditionVisit((Condition)this.outboundConditionCache).accept((Visitor)visitor);
        }
        return result;
    }

    public void setParameterStore(final ParameterStore store) {
        this.store = store;
        this.requestPath.setParameterStore(store);
        this.resourcePath.setParameterStore(store);
        if (this.outboundConditionCache != null) {
            ParameterizedConditionVisitor visitor = new ParameterizedConditionVisitor(new ParameterizedCallback(){

                public void call(Parameterized parameterized) {
                    parameterized.setParameterStore(store);
                }
            });
            new ConditionVisit((Condition)this.outboundConditionCache).accept((Visitor)visitor);
        }
    }
}

