/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class SendStatus
extends HttpOperation {
    private final int code;
    private String message;

    private SendStatus(int code) {
        this.code = code;
    }

    private SendStatus(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            if (this.getMessage() != null) {
                ((HttpInboundServletRewrite)event).sendStatusCode(this.getCode(), this.getMessage());
            } else {
                ((HttpInboundServletRewrite)event).sendStatusCode(this.getCode());
            }
        }
    }

    protected int getCode() {
        return this.code;
    }

    protected String getMessage() {
        return this.message;
    }

    public static SendStatus code(final int code) {
        return new SendStatus(code){

            public String toString() {
                return "SendStatus.code(" + code + ")";
            }
        };
    }

    public static SendStatus error(final int code) {
        return new SendError(code, null){

            public String toString() {
                return "SendStatus.error(" + code + ")";
            }
        };
    }

    public static SendStatus error(final int code, final String message) {
        return new SendError(code, message){

            public String toString() {
                return "SendStatus.error(" + code + ", \"" + message + "\")";
            }
        };
    }

    private static abstract class SendError
    extends SendStatus {
        public SendError(int code, String message) {
            super(code, message);
        }

        @Override
        public void performHttp(HttpServletRewrite event, EvaluationContext context) {
            if (event instanceof HttpInboundServletRewrite) {
                if (this.getMessage() != null) {
                    ((HttpInboundServletRewrite)event).sendErrorCode(this.getCode(), this.getMessage());
                } else {
                    ((HttpInboundServletRewrite)event).sendErrorCode(this.getCode());
                }
            }
        }
    }
}

