/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Strings;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class Method
extends HttpCondition {
    private final HttpMethod method;

    public String toString() {
        return "Method.is" + Strings.capitalize((String)this.method.name().toLowerCase()) + "()";
    }

    private Method(HttpMethod method) {
        this.method = method;
    }

    public static Method isGet() {
        return new Method(HttpMethod.GET){};
    }

    public static Method isPost() {
        return new Method(HttpMethod.POST){};
    }

    public static Method isHead() {
        return new Method(HttpMethod.HEAD){};
    }

    public static Method isOptions() {
        return new Method(HttpMethod.OPTIONS){};
    }

    public static Method isPut() {
        return new Method(HttpMethod.PUT){};
    }

    public static Method isDelete() {
        return new Method(HttpMethod.DELETE){};
    }

    public static Method isTrace() {
        return new Method(HttpMethod.TRACE){};
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        return this.method.equals((Object)HttpMethod.valueOf(((HttpServletRequest)event.getRequest()).getMethod()));
    }

    private static enum HttpMethod {
        GET,
        POST,
        HEAD,
        OPTIONS,
        PUT,
        DELETE,
        TRACE;

    }
}

