/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Set;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternBuilder;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.util.Transpositions;

public abstract class Redirect
extends HttpOperation
implements Parameterized {
    private final RedirectType type;
    private final RegexParameterizedPatternBuilder location;

    private Redirect(String location, RedirectType type) {
        this.location = new RegexParameterizedPatternBuilder("[^/]+", location);
        this.type = type;
    }

    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            String target = this.location.build((Rewrite)event, context, Transpositions.encodePath());
            switch (this.type) {
                case PERMANENT: {
                    ((HttpInboundServletRewrite)event).redirectPermanent(target);
                    break;
                }
                case TEMPORARY: {
                    ((HttpInboundServletRewrite)event).redirectTemporary(target);
                    break;
                }
            }
        }
    }

    public static Redirect permanent(final String location) {
        return new Redirect(location, RedirectType.PERMANENT){

            public String toString() {
                return "Redirect.permanent(\"" + location + "\")";
            }
        };
    }

    public static Redirect temporary(final String location) {
        return new Redirect(location, RedirectType.TEMPORARY){

            public String toString() {
                return "Redirect.temporary(\"" + location + "\")";
            }
        };
    }

    public RegexParameterizedPatternBuilder getTargetExpression() {
        return this.location;
    }

    public Set<String> getRequiredParameterNames() {
        return this.location.getRequiredParameterNames();
    }

    public void setParameterStore(ParameterStore store) {
        this.location.setParameterStore(store);
    }

    private static enum RedirectType {
        PERMANENT(301),
        TEMPORARY(302);

        private int code;

        private RedirectType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

