/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class Request
extends HttpOperation {
    public static Request setCharacterEncoding(final String encoding) {
        return new Request(){

            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                try {
                    ((HttpServletRequest)event.getRequest()).setCharacterEncoding(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Failed to set encoding " + encoding, e);
                }
            }

            public String toString() {
                return "Request.setCharacterEncoding(\"" + encoding + "\")";
            }
        };
    }

    public static Request setCharacterEncoding(Charset charset) {
        return Request.setCharacterEncoding(charset.name());
    }

    public static Request setAttribute(final String name, final Object value) {
        return new Request(){

            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                ((HttpServletRequest)event.getRequest()).setAttribute(name, value);
            }

            public String toString() {
                return "Request.setAttribute(\"" + name + "\", \"" + value + "\")";
            }
        };
    }
}

