/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config.tuckey;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.tuckey.shade.Conf;
import org.ocpsoft.rewrite.bind.tuckey.shade.UrlRewriter;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.tuckey.TuckeyRewriteRuleAdaptor;
import org.ocpsoft.rewrite.servlet.config.HttpConfigurationProvider;

public class TuckeyConfigurationProvider
extends HttpConfigurationProvider {
    Logger log = Logger.getLogger(TuckeyConfigurationProvider.class);
    private UrlRewriter urlRewriter;

    public Configuration getConfiguration(ServletContext context) {
        this.loadUrlRewriteConfig(context);
        ConfigurationBuilder config = ConfigurationBuilder.begin();
        if (this.urlRewriter != null) {
            config.addRule((Rule)new TuckeyRewriteRuleAdaptor(this.urlRewriter));
        }
        return config;
    }

    private void loadUrlRewriteConfig(ServletContext context) {
        String confPath = "/WEB-INF/urlrewrite.xml";
        InputStream inputStream = context.getResourceAsStream(confPath);
        if (inputStream == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(confPath);
        }
        URL confUrl = null;
        try {
            confUrl = context.getResource(confPath);
        }
        catch (MalformedURLException e) {
            this.log.debug("Error", (Throwable)e);
        }
        String confUrlStr = null;
        if (confUrl != null) {
            confUrlStr = confUrl.toString();
        }
        if (inputStream == null) {
            this.log.error("unable to find urlrewrite conf file at " + confPath);
            if (this.urlRewriter != null) {
                this.log.error("unloading existing conf");
                this.urlRewriter = null;
            }
        } else {
            Conf conf = new Conf(context, inputStream, confPath, confUrlStr, false);
            this.checkConfLocal(conf);
        }
    }

    private void checkConfLocal(Conf conf) {
        if (conf.isOk() && conf.isEngineEnabled()) {
            this.urlRewriter = new UrlRewriter(conf);
            this.log.debug("Tuckey UrlRewriteFilter configuration loaded (Status: OK)");
        } else {
            if (!conf.isOk()) {
                this.log.error("Tuckey UrlRewriteFilter configuration failed (Status: ERROR)");
            }
            if (!conf.isEngineEnabled()) {
                this.log.warn("Tuckey UrlRewriteFilter engine explicitly disabled in configuration");
            }
            if (this.urlRewriter != null) {
                this.log.debug("Tuckey UrlRewriteFilter configuration unloaded");
                this.urlRewriter = null;
            }
        }
    }

    public int priority() {
        return 100;
    }
}

