/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.bind.tuckey.shade.test;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletException;
import junit.framework.TestCase;
import org.ocpsoft.rewrite.bind.tuckey.shade.Conf;
import org.ocpsoft.rewrite.bind.tuckey.shade.NormalRewrittenUrl;
import org.ocpsoft.rewrite.bind.tuckey.shade.Rule;
import org.ocpsoft.rewrite.bind.tuckey.shade.UrlRewriter;
import org.ocpsoft.rewrite.bind.tuckey.shade.test.MockRequest;
import org.ocpsoft.rewrite.bind.tuckey.shade.test.MockResponse;
import org.ocpsoft.rewrite.bind.tuckey.shade.utils.Log;

public class UrlRewriteTestCase
extends TestCase {
    Conf conf;
    UrlRewriter urlRewriter;

    public void loadConf(URL confFileUrl) {
        Log.setLevel("SYSOUT:DEBUG");
        this.conf = new Conf(confFileUrl);
        UrlRewriteTestCase.assertTrue((String)"Conf should load without errors", (boolean)this.conf.isOk());
        this.urlRewriter = new UrlRewriter(this.conf);
    }

    public void assertRuleMatches(String ruleName, String requestUrl) {
        List rules = this.urlRewriter.getConf().getRules();
        Rule rule = null;
        if (rules != null) {
            for (int i = 0; i < rules.size(); ++i) {
                Rule loopRule = (Rule)rules.get(i);
                if (!ruleName.equalsIgnoreCase(loopRule.getName())) continue;
                rule = loopRule;
            }
        }
        if (rule == null) {
            UrlRewriteTestCase.assertTrue((String)("Rule by the name " + ruleName + " does not exist"), (boolean)false);
            return;
        }
        MockResponse response = new MockResponse();
        MockRequest request = new MockRequest(requestUrl);
        NormalRewrittenUrl rewrittenUrl = null;
        try {
            rewrittenUrl = (NormalRewrittenUrl)rule.matches(request.getRequestURI(), request, response);
        }
        catch (IOException e) {
            UrlRewriteTestCase.assertNull((String)("IOException during rule matching " + e.toString()), (Object)e);
        }
        catch (ServletException e) {
            UrlRewriteTestCase.assertNull((String)("ServletException during rule matching " + e.toString()), (Object)((Object)e));
        }
        catch (InvocationTargetException e) {
            UrlRewriteTestCase.assertNull((String)("InvocationTargetException during rule matching " + e.toString()), (Object)e);
        }
        UrlRewriteTestCase.assertNotNull((String)("Rule " + ruleName + " does not match"), (Object)rewrittenUrl);
    }

    public void testUrlRerwriteTestCase() {
    }
}

