/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexCapture;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IScheme;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.ParameterStore;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;

public class Scheme
extends HttpCondition
implements IScheme {
    private final ParameterizedPattern expression;
    private final ParameterStore<IScheme.SchemeParameter> parameters = new ParameterStore();

    private Scheme(String pattern) {
        Assert.notNull(pattern, "Scheme must not be null.");
        this.expression = new ParameterizedPattern(pattern);
        for (RegexCapture parameter : this.expression.getParameters().values()) {
            this.where(parameter.getName()).bindsTo(Evaluation.property(parameter.getName()));
        }
    }

    public static Scheme matches(String pattern) {
        return new Scheme(pattern);
    }

    @Override
    public IScheme.SchemeParameter where(String param) {
        return this.parameters.where(param, new IScheme.SchemeParameter(this, this.expression.getParameter(param)));
    }

    @Override
    public IScheme.SchemeParameter where(String param, Binding binding) {
        return (IScheme.SchemeParameter)this.where(param).bindsTo(binding);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String scheme = null;
        if (event instanceof HttpOutboundServletRewrite) {
            String url = event.getURL();
            URLBuilder builder = URLBuilder.createFrom(url);
            scheme = builder.toURI().getScheme();
            if (scheme == null) {
                scheme = ((HttpServletRequest)event.getRequest()).getScheme();
            }
        } else {
            scheme = ((HttpServletRequest)event.getRequest()).getScheme();
        }
        if (scheme != null && this.expression.matches(event, context, scheme)) {
            Map<RegexCapture, String[]> parameters = this.expression.parse(event, context, scheme);
            for (RegexCapture capture : parameters.keySet()) {
                if (Bindings.enqueueSubmission(event, context, this.where(capture.getName()), parameters.get(capture))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ParameterizedPattern getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }
}

