/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexCapture;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IURL;
import org.ocpsoft.rewrite.servlet.config.bind.Request;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.ParameterStore;

public class URL
extends HttpCondition
implements IURL {
    private final ParameterizedPattern expression;
    private final ParameterStore<IURL.URLParameter> parameters = new ParameterStore();

    private URL(String pattern) {
        Assert.notNull(pattern, "URL must not be null.");
        this.expression = new ParameterizedPattern(".*", pattern);
        for (RegexCapture parameter : this.expression.getParameters().values()) {
            this.where(parameter.getName()).bindsTo(Evaluation.property(parameter.getName()));
        }
    }

    public static URL matches(String pattern) {
        return new URL(pattern);
    }

    public static URL captureIn(String param) {
        URL path = new URL("{" + param + "}");
        return path;
    }

    @Override
    public URL withRequestBinding() {
        for (RegexCapture capture : this.expression.getParameters().values()) {
            this.where(capture.getName()).bindsTo(Request.parameter(capture.getName()));
        }
        return this;
    }

    @Override
    public IURL.URLParameter where(String param) {
        return this.parameters.where(param, new IURL.URLParameter(this, this.expression.getParameter(param)));
    }

    @Override
    public IURL.URLParameter where(String param, Binding binding) {
        return (IURL.URLParameter)this.where(param).bindsTo(binding);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String requestURL = null;
        if (event instanceof HttpOutboundServletRewrite) {
            requestURL = ((HttpOutboundServletRewrite)event).getOutboundURL();
            if (requestURL.startsWith(event.getContextPath())) {
                requestURL = requestURL.substring(event.getContextPath().length());
            }
        } else {
            HttpServletRequest request = (HttpServletRequest)event.getRequest();
            requestURL = event.getContextPath() + event.getURL();
            requestURL = request.getScheme() + "://" + request.getServerName() + (request.getServerPort() != 80 ? ":" + request.getServerPort() : "") + requestURL;
        }
        if (this.expression.matches(event, context, requestURL)) {
            Map<RegexCapture, String[]> parameters = this.expression.parse(event, context, requestURL);
            for (RegexCapture capture : parameters.keySet()) {
                if (Bindings.enqueueSubmission(event, context, this.where(capture.getName()), parameters.get(capture))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ParameterizedPattern getSchemeExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public ParameterizedPattern getPathExpression() {
        return this.expression;
    }
}

