/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.annotation.api.ClassContext;
import org.ocpsoft.rewrite.annotation.api.ClassVisitor;
import org.ocpsoft.rewrite.annotation.scan.ClassContextImpl;
import org.ocpsoft.rewrite.annotation.spi.AnnotationHandler;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleBuilder;

public class ClassVisitorImpl
implements ClassVisitor,
Configuration {
    private final Logger log = Logger.getLogger(ClassVisitorImpl.class);
    private final Map<Class<Annotation>, List<AnnotationHandler<Annotation>>> handlerMap = new HashMap<Class<Annotation>, List<AnnotationHandler<Annotation>>>();
    private final ConfigurationBuilder builder = ConfigurationBuilder.begin();

    public ClassVisitorImpl(List<AnnotationHandler<Annotation>> handlers) {
        for (AnnotationHandler<Annotation> handler : handlers) {
            Class annotationType = handler.handles();
            List<AnnotationHandler<Annotation>> list = this.handlerMap.get(annotationType);
            if (list == null) {
                list = new ArrayList<AnnotationHandler<Annotation>>();
                this.handlerMap.put(annotationType, list);
            }
            list.add(handler);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Initialized to use {} AnnotationHandlers..", (Object)handlers.size());
        }
    }

    public void visit(Class<?> clazz) {
        ClassContextImpl context = new ClassContextImpl(this.builder, RuleBuilder.define());
        if (this.log.isTraceEnabled()) {
            this.log.trace("Scanning class: {}", (Object)clazz.getName());
        }
        this.visit(clazz, context);
        for (Field field : clazz.getDeclaredFields()) {
            this.visit(field, context);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            this.visit(accessibleObject, context);
        }
    }

    private void visit(AnnotatedElement element, ClassContext context) {
        for (Annotation annotation : element.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            List<AnnotationHandler<Annotation>> handlers = this.handlerMap.get(annotationType);
            if (handlers == null) continue;
            for (AnnotationHandler<Annotation> handler : handlers) {
                handler.process(context, element, annotation);
            }
        }
    }

    public List<Rule> getRules() {
        return this.builder.getRules();
    }
}

