/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.ocpsoft.rewrite.annotation.api.ClassVisitor;
import org.ocpsoft.rewrite.annotation.scan.AbstractClassFinder;
import org.ocpsoft.rewrite.annotation.scan.ByteCodeFilter;
import org.ocpsoft.rewrite.annotation.scan.PackageFilter;

public class WebClassesFinder
extends AbstractClassFinder {
    private static final String CLASSES_FOLDER = "/WEB-INF/classes/";
    private final Set<String> processedClasses = new HashSet<String>();

    public WebClassesFinder(ServletContext servletContext, ClassLoader classLoader, PackageFilter packageFilter, ByteCodeFilter byteCodeFilter) {
        super(servletContext, classLoader, packageFilter, byteCodeFilter);
    }

    public void findClasses(ClassVisitor visitor) {
        try {
            URL classesFolderUrl = this.servletContext.getResource(CLASSES_FOLDER);
            if (classesFolderUrl == null) {
                this.log.warn("Cannot find classes folder: /WEB-INF/classes/");
                return;
            }
            this.processDirectory(classesFolderUrl, classesFolderUrl, visitor);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDirectory(URL classesFolderUrl, URL directoryUrl, ClassVisitor visitor) throws MalformedURLException {
        String classesFolderPath = classesFolderUrl.getPath();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Processing directory: " + directoryUrl.toString());
        }
        String relativeDirectoryName = this.getPathRelativeToClassesFolder(directoryUrl.getPath(), classesFolderPath);
        Set paths = this.servletContext.getResourcePaths(CLASSES_FOLDER + relativeDirectoryName);
        if (paths != null) {
            for (Object relativePath : paths) {
                String entryRelativeName;
                String className;
                URL entryUrl = this.servletContext.getResource(relativePath.toString());
                if (entryUrl.getPath().endsWith(".class") && this.mustProcessClass(className = WebClassesFinder.getClassName(entryRelativeName = this.getPathRelativeToClassesFolder(entryUrl.getPath(), classesFolderPath))) && !this.processedClasses.contains(className)) {
                    this.processedClasses.add(className);
                    InputStream classFileStream = null;
                    try {
                        block14: {
                            try {
                                classFileStream = entryUrl.openStream();
                            }
                            catch (IOException e) {
                                if (!this.log.isDebugEnabled()) break block14;
                                this.log.debug("Cound not obtain InputStream for class file: " + entryUrl.toString(), (Throwable)e);
                            }
                        }
                        this.processClass(className, classFileStream, visitor);
                    }
                    finally {
                        block16: {
                            try {
                                if (classFileStream != null) {
                                    classFileStream.close();
                                }
                            }
                            catch (IOException e) {
                                if (!this.log.isDebugEnabled()) break block16;
                                this.log.debug("Failed to close input stream: " + e.getMessage());
                            }
                        }
                    }
                }
                if (!entryUrl.getPath().endsWith("/")) continue;
                this.processDirectory(classesFolderUrl, entryUrl, visitor);
            }
        }
    }

    private String getPathRelativeToClassesFolder(String path, String classesFolderPath) {
        String result = this.stripKnownPrefix(path, CLASSES_FOLDER);
        if (result == null) {
            result = this.stripKnownPrefix(path, classesFolderPath);
        }
        if (result == null) {
            throw new IllegalArgumentException("Unable to build path relative to '/WEB-INF/classes/' from: " + path);
        }
        return result;
    }
}

