/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.bind.tuckey.shade.test;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ocpsoft.rewrite.bind.tuckey.shade.test.MockRequest;
import org.ocpsoft.rewrite.bind.tuckey.shade.utils.Log;
import org.ocpsoft.rewrite.bind.tuckey.shade.utils.StringUtils;

public class MockRequestParser {
    private static Log log = Log.getLog(class$org$tuckey$web$filters$urlrewrite$test$MockRequestParser == null ? (class$org$tuckey$web$filters$urlrewrite$test$MockRequestParser = MockRequestParser.class$("org.ocpsoft.rewrite.bind.tuckey.shade.test.MockRequestParser")) : class$org$tuckey$web$filters$urlrewrite$test$MockRequestParser);
    Pattern FIRST_LINE_PATTERN = Pattern.compile("^([A-Z]+) (.*) ([A-Z0-9/\\.]+)$");
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$test$MockRequestParser;

    public MockRequest decodeRequest(String requestString) {
        return this.decodeRequest(requestString.split("\n"));
    }

    public MockRequest decodeRequest(String[] requestLines) {
        int semiColonIdx;
        String requestPart;
        MockRequest request = new MockRequest();
        request.setRemoteAddr("127.0.0.1");
        request.setRemoteHost("localhost");
        String line1 = requestLines[0];
        Matcher line1Matcher = this.FIRST_LINE_PATTERN.matcher(line1);
        if (line1Matcher.matches()) {
            request.setMethod(line1Matcher.group(1));
            requestPart = line1Matcher.group(2);
            request.setScheme(line1Matcher.group(3));
        } else {
            requestPart = line1;
        }
        String requestUri = requestPart;
        int questionMarkIdx = requestPart.indexOf(63);
        if (questionMarkIdx != -1) {
            String queryString = requestPart.substring(questionMarkIdx + 1);
            this.setParams(request, queryString);
            requestUri = requestPart.substring(0, questionMarkIdx);
        }
        if ((semiColonIdx = requestUri.indexOf(59)) != -1) {
            String sessionId = requestUri.substring(semiColonIdx + 1);
            int equalsIdx = sessionId.indexOf(61);
            if (equalsIdx != -1) {
                sessionId = sessionId.substring(equalsIdx + 1);
            }
            request.setRequestedSessionId(sessionId);
            requestUri = requestUri.substring(0, semiColonIdx);
        }
        request.setRequestURI(requestUri);
        if (requestLines.length > 1) {
            boolean parsingBody = false;
            for (int i = 0; i < requestLines.length; ++i) {
                if (i == 0) continue;
                String line = requestLines[i];
                if (!parsingBody) {
                    if (line.length() == 0) {
                        parsingBody = true;
                        continue;
                    }
                    int colonIdx = line.indexOf(58);
                    if (colonIdx < 1) {
                        log.debug("cannot parse line " + line);
                        continue;
                    }
                    String headerName = StringUtils.trimToNull(line.substring(0, colonIdx));
                    String headerValue = StringUtils.trimToNull(line.substring(colonIdx + 1));
                    if (headerName == null) {
                        log.debug("cannot parse line " + line);
                        continue;
                    }
                    request.setHeader(headerName, headerValue);
                    if (!"host".equals(headerName.toLowerCase())) continue;
                    request.setServerName(headerValue);
                    continue;
                }
                this.setParams(request, line);
            }
        }
        return request;
    }

    private void setParams(MockRequest request, String queryString) {
        request.setQueryString(queryString);
        if (queryString.indexOf(38) != -1) {
            String[] paramSets = queryString.split("&");
            for (int i = 0; i < paramSets.length; ++i) {
                this.addParamSet(request, paramSets[i]);
            }
        } else {
            this.addParamSet(request, queryString);
        }
    }

    private void addParamSet(MockRequest request, String paramSet) {
        if (paramSet.indexOf("=") != -1) {
            String[] nameVal = paramSet.split("=", 2);
            request.addParameter(nameVal[0], nameVal[1]);
        } else {
            log.info("cannot find value of request parameter " + paramSet);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

