/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces;

import java.util.ArrayList;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.faces.NavigatingInvocationResultHandler;
import org.ocpsoft.rewrite.faces.config.PhaseAction;
import org.ocpsoft.rewrite.faces.config.PhaseOperation;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.event.ServletRewrite;
import org.ocpsoft.rewrite.servlet.event.SubflowTask;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class RewritePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 6706075446314218089L;
    private static Logger log = Logger.getLogger(RewritePhaseListener.class);

    public RewritePhaseListener() {
        log.info(RewritePhaseListener.class.getSimpleName() + " starting up.");
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        if (!PhaseId.RESTORE_VIEW.equals(event.getPhaseId())) {
            this.handleBeforePhaseOperations(event);
        }
        if (PhaseId.RENDER_RESPONSE.equals(event.getPhaseId())) {
            this.handleNavigation(event);
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (!PhaseId.RENDER_RESPONSE.equals(event.getPhaseId())) {
            this.handleAfterPhaseOperations(event);
            this.handleNavigation(event);
        }
    }

    private void handleBeforePhaseOperations(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        ArrayList<PhaseOperation<?>> operations = PhaseOperation.getSortedPhaseOperations(request);
        if (operations != null) {
            for (final PhaseOperation<?> operation : operations) {
                if (!operation.getBeforePhases().contains(event.getPhaseId()) && !operation.getBeforePhases().contains(PhaseId.ANY_PHASE)) continue;
                BaseRewrite.Flow flow = SubflowTask.perform((ServletRewrite)operation.getEvent(), (EvaluationContext)operation.getContext(), (BaseRewrite.Flow)BaseRewrite.Flow.UN_HANDLED, (SubflowTask)new SubflowTask(){

                    public void performInSubflow(ServletRewrite<?, ?> rewriteEvent, EvaluationContext context) {
                        operation.performOperation((HttpServletRewrite)rewriteEvent, context);
                    }
                });
                if (flow.is(BaseRewrite.Flow.ABORT_REQUEST)) {
                    event.getFacesContext().responseComplete();
                }
                if (!flow.is(BaseRewrite.Flow.HANDLED)) continue;
                break;
            }
        }
    }

    private void handleAfterPhaseOperations(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        ArrayList<PhaseOperation<?>> operations = PhaseOperation.getSortedPhaseOperations(request);
        if (operations != null) {
            for (final PhaseOperation<?> operation : operations) {
                if (!operation.getAfterPhases().contains(event.getPhaseId()) && !operation.getAfterPhases().contains(PhaseId.ANY_PHASE)) continue;
                try {
                    BaseRewrite.Flow flow = SubflowTask.perform((ServletRewrite)operation.getEvent(), (EvaluationContext)operation.getContext(), (BaseRewrite.Flow)BaseRewrite.Flow.UN_HANDLED, (SubflowTask)new SubflowTask(){

                        public void performInSubflow(ServletRewrite<?, ?> rewriteEvent, EvaluationContext context) {
                            operation.performOperation((HttpServletRewrite)rewriteEvent, context);
                        }
                    });
                    if (flow.is(BaseRewrite.Flow.ABORT_REQUEST)) {
                        event.getFacesContext().responseComplete();
                    }
                    if (!flow.is(BaseRewrite.Flow.HANDLED)) continue;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void handleNavigation(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        String navigationCase = (String)request.getAttribute(NavigatingInvocationResultHandler.QUEUED_NAVIGATION);
        if (navigationCase != null) {
            request.setAttribute(NavigatingInvocationResultHandler.QUEUED_NAVIGATION, null);
            NavigationHandler navigationHandler = facesContext.getApplication().getNavigationHandler();
            log.debug("Passing queued " + PhaseAction.class.getName() + " result [" + navigationCase + "] to NavigationHandler.handleNavigation()");
            navigationHandler.handleNavigation(facesContext, "", navigationCase);
        }
    }
}

