/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.rewrite.faces.FacesRewriteLifecycleListener;
import org.ocpsoft.rewrite.faces.RewriteNavigationHandler;
import org.ocpsoft.rewrite.faces.URLDuplicatePathCanonicalizer;

public class RewriteViewHandler
extends ViewHandler {
    protected ViewHandler parent;
    private final ThreadLocal<Boolean> bookmarkable = new ThreadLocal();

    private boolean isBookmarkable() {
        Boolean result = this.bookmarkable.get();
        if (result == null) {
            result = false;
            this.bookmarkable.set(result);
        }
        return result;
    }

    public String deriveLogicalViewId(FacesContext context, String rawViewId) {
        return this.parent.deriveLogicalViewId(context, rawViewId);
    }

    private void setBookmarkable(boolean value) {
        this.bookmarkable.set(value);
    }

    public RewriteViewHandler(ViewHandler viewHandler) {
        this.parent = viewHandler;
    }

    public Locale calculateLocale(FacesContext facesContext) {
        return this.parent.calculateLocale(facesContext);
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        return this.parent.calculateRenderKitId(facesContext);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot view = this.parent.createView(context, viewId);
        return view;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        UIViewRoot view = this.parent.restoreView(context, viewId);
        return view;
    }

    public String getActionURL(FacesContext context, String viewId) {
        String result = this.parent.getActionURL(context, viewId);
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        if (!this.isBookmarkable() && !RewriteNavigationHandler.isInNavigation(request) && viewId != null && viewId.equals(context.getViewRoot().getViewId())) {
            result = FacesRewriteLifecycleListener.getOriginalRequestURL(request);
        }
        return result;
    }

    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        this.setBookmarkable(true);
        String result = this.parent.getBookmarkableURL(context, viewId, parameters, includeViewParams);
        this.setBookmarkable(false);
        return result;
    }

    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        return this.parent.getRedirectURL(context, viewId, parameters, includeViewParams);
    }

    public String getResourceURL(FacesContext facesContext, String path) {
        return this.parent.getResourceURL(facesContext, path);
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewRoot) throws IOException, FacesException {
        this.parent.renderView(facesContext, viewRoot);
    }

    public void writeState(FacesContext facesContext) throws IOException {
        this.parent.writeState(facesContext);
    }

    public String deriveViewId(FacesContext context, String rawViewId) {
        String canonicalViewId = new URLDuplicatePathCanonicalizer().canonicalize(rawViewId);
        return this.parent.deriveViewId(context, canonicalViewId);
    }

    public String calculateCharacterEncoding(FacesContext context) {
        return this.parent.calculateCharacterEncoding(context);
    }

    public ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext context, String viewId) {
        return this.parent.getViewDeclarationLanguage(context, viewId);
    }

    public void initView(FacesContext context) throws FacesException {
        this.parent.initView(context);
    }
}

