/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.el;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.BindingBuilder;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.bind.Retrieval;
import org.ocpsoft.rewrite.bind.Validator;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.el.ConstantExpression;
import org.ocpsoft.rewrite.el.Expression;
import org.ocpsoft.rewrite.el.TypeBasedExpression;
import org.ocpsoft.rewrite.el.spi.ExpressionLanguageProvider;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.exception.UnsupportedEvaluationException;

public abstract class El
extends BindingBuilder<El, Object>
implements Retrieval {
    private static final Logger log = Logger.getLogger(El.class);
    private static List<ExpressionLanguageProvider> providers;

    public static El methodBinding(String retrieve, String submit) {
        return new ElMethod(new ConstantExpression(retrieve), new ConstantExpression(submit));
    }

    public static El retrievalMethod(String expression) {
        return new ElMethod(new ConstantExpression(expression), null);
    }

    public static El retrievalMethod(Method method) {
        return new ElMethod(new TypeBasedExpression(method.getDeclaringClass(), method.getName()), null);
    }

    public static El retrievalMethod(String expression, Class<? extends Converter<?>> converterType) {
        ElMethod el = new ElMethod(new ConstantExpression(expression), null);
        el.convertedBy(converterType);
        return el;
    }

    public static El submissionMethod(String expression) {
        return new ElMethod(null, new ConstantExpression(expression));
    }

    public static El submissionMethod(String expression, Class<? extends Converter<?>> converterType) {
        ElMethod el = new ElMethod(null, new ConstantExpression(expression));
        el.convertedBy(converterType);
        return el;
    }

    public static El submissionMethod(String expression, Class<? extends Converter<?>> converterType, Class<? extends Validator<?>> validatorType) {
        ElMethod el = new ElMethod(null, new ConstantExpression(expression));
        el.convertedBy(converterType);
        el.validatedBy(validatorType);
        return el;
    }

    public static El property(String expression) {
        return new ElProperty(new ConstantExpression(expression));
    }

    public static El property(Field field) {
        return new ElProperty(new TypeBasedExpression(field.getDeclaringClass(), field.getName()));
    }

    public static El property(String expression, Class<? extends Converter<?>> type) {
        ElProperty el = new ElProperty(new ConstantExpression(expression));
        el.convertedBy(type);
        return el;
    }

    public static El property(String expression, Class<? extends Converter<?>> converterType, Class<? extends Validator<?>> validatorType) {
        ElProperty el = new ElProperty(new ConstantExpression(expression));
        el.convertedBy(converterType);
        el.validatedBy(validatorType);
        return el;
    }

    private static List<ExpressionLanguageProvider> getProviders() {
        if (providers == null) {
            ServiceLoader serviceProviders = ServiceLoader.load(ExpressionLanguageProvider.class);
            providers = Iterators.asList(serviceProviders);
        }
        return providers;
    }

    public static class ElProperty
    extends El {
        private final Expression expression;

        public ElProperty(Expression expression) {
            this.expression = expression;
        }

        @Override
        public Object retrieve(Rewrite event, EvaluationContext context) {
            ServiceLoader providers = ServiceLoader.load(ExpressionLanguageProvider.class);
            Object value = null;
            for (ExpressionLanguageProvider provider : providers) {
                try {
                    value = provider.retrieveValue(this.expression.getExpression());
                    break;
                }
                catch (UnsupportedEvaluationException e) {
                    log.debug("El provider [" + provider.getClass().getName() + "] could not extract value from property [" + this.expression + "]", e);
                }
                catch (Exception e) {
                    throw new RewriteException("El provider [" + provider.getClass().getName() + "] could not extract value from property [" + this.expression + "]", e);
                }
                if (value == null) continue;
                break;
            }
            return value;
        }

        @Override
        public boolean supportsRetrieval() {
            return true;
        }

        @Override
        public boolean supportsSubmission() {
            return true;
        }

        @Override
        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            ServiceLoader providers = ServiceLoader.load(ExpressionLanguageProvider.class);
            if (!providers.iterator().hasNext()) {
                log.warn("No instances of [{}] were configured. EL support is disabled.", ExpressionLanguageProvider.class.getName());
            }
            for (ExpressionLanguageProvider provider : providers) {
                try {
                    provider.submitValue(this.expression.getExpression(), value);
                    break;
                }
                catch (UnsupportedEvaluationException e) {
                    log.debug("El provider [" + provider.getClass().getName() + "] could not inject property [" + this.expression + "} with value [" + value + "]", e);
                }
                catch (Exception e) {
                    throw new RewriteException("El provider [" + provider.getClass().getName() + "] could not inject property [" + this.expression + "} with value [" + value + "]", e);
                }
            }
            return null;
        }

        public String toString() {
            return "ElProperty [ " + this.expression + " ]";
        }
    }

    public static class ElMethod
    extends El {
        private final Expression getExpression;
        private final Expression setExpression;

        public ElMethod(Expression getExpression, Expression setExpression) {
            this.getExpression = getExpression;
            this.setExpression = setExpression;
        }

        @Override
        public Object retrieve(Rewrite event, EvaluationContext context) {
            ServiceLoader providers = ServiceLoader.load(ExpressionLanguageProvider.class);
            if (!this.supportsRetrieval()) {
                throw new RewriteException("Method binding expression supports submission only [" + this.setExpression + "], no value retrieval expression was defined");
            }
            Object value = null;
            for (ExpressionLanguageProvider provider : providers) {
                try {
                    return provider.evaluateMethodExpression(this.getExpression.getExpression());
                }
                catch (UnsupportedEvaluationException e) {
                    log.debug("El provider [" + provider.getClass().getName() + "] could not invoke method [" + this.getExpression + "]", e);
                }
                catch (Exception e) {
                    throw new RewriteException("El provider [" + provider.getClass().getName() + "] could not retrieve value from property [" + this.getExpression + "]", e);
                }
            }
            return value;
        }

        @Override
        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            if (!this.supportsSubmission()) {
                throw new RewriteException("Method binding expression supports retrieval only [" + this.getExpression + "], no value submission expression was defined");
            }
            for (ExpressionLanguageProvider provider : El.getProviders()) {
                try {
                    return provider.evaluateMethodExpression(this.setExpression.getExpression(), value);
                }
                catch (UnsupportedEvaluationException e) {
                    log.debug("El provider [" + provider.getClass().getName() + "] could not submit method [" + this.setExpression + "} with value [" + value + "]", e);
                }
                catch (Exception e) {
                    throw new RewriteException("El provider [" + provider.getClass().getName() + "] could not submit method [" + this.setExpression + "} with value [" + value + "]", e);
                }
            }
            return null;
        }

        @Override
        public boolean supportsRetrieval() {
            return this.getExpression != null;
        }

        @Override
        public boolean supportsSubmission() {
            return this.setExpression != null;
        }

        public String toString() {
            return "ElMethod [retrieve= [ " + this.getExpression + " }, submit= [ " + this.setExpression + " ]";
        }
    }
}

