/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.DefaultBindable;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.InboundRewrite;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.QueryStringBuilder;
import org.ocpsoft.rewrite.util.Maps;

public abstract class QueryString
extends HttpCondition
implements Bindable<QueryString> {
    protected final DefaultBindable<?> bindable = new DefaultBindable();

    @Override
    public QueryString bindsTo(Binding binding) {
        this.bindable.bindsTo(binding);
        return this;
    }

    @Override
    public List<Binding> getBindings() {
        return this.bindable.getBindings();
    }

    public static QueryString matches(final String pattern) {
        Assert.notNull(pattern, "URL pattern must not be null.");
        return new QueryString(){

            @Override
            public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
                String queryString = null;
                if (event instanceof InboundRewrite) {
                    queryString = event.getRequestQueryString();
                } else if (event instanceof HttpOutboundServletRewrite) {
                    queryString = QueryStringBuilder.createFrom(event.getURL()).toQueryString();
                }
                if (Pattern.compile(pattern).matcher(queryString == null ? "" : queryString).matches()) {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(queryString);
                    Bindings.enqueueSubmission(event, context, this.bindable, values.toArray(new String[0]));
                    return true;
                }
                return false;
            }
        };
    }

    public static QueryString parameterExists(final String nameRegex) {
        Assert.notNull(nameRegex, "Parameter name pattern must not be null.");
        return new QueryString(){

            @Override
            public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
                Pattern pattern = Pattern.compile(nameRegex);
                QueryStringBuilder queryString = null;
                queryString = QueryStringBuilder.createFrom(event.getURL());
                ArrayList<String> values = new ArrayList<String>();
                LinkedHashMap<DefaultBindable, String[]> map = new LinkedHashMap<DefaultBindable, String[]>();
                for (String name : queryString.getParameterNames()) {
                    if (!pattern.matcher(name).matches()) continue;
                    String[] temp = queryString.getParameterValues(name);
                    DefaultBindable tempBindable = new DefaultBindable();
                    tempBindable.bindsTo(Evaluation.property(name));
                    map.put(tempBindable, temp);
                    values.addAll(Arrays.asList(temp));
                }
                map.put(this.bindable, values.toArray(new String[0]));
                if (!values.isEmpty()) {
                    return Bindings.enqueuePreOperationSubmissions(event, context, map);
                }
                return false;
            }
        };
    }

    public static QueryString valueExists(final String valueRegex) {
        Assert.notNull(valueRegex, "Parameter value pattern must not be null.");
        return new QueryString(){

            @Override
            public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
                Pattern pattern = Pattern.compile(valueRegex);
                QueryStringBuilder queryString = QueryStringBuilder.createFrom(event.getRequestQueryString());
                ArrayList<String> values = new ArrayList<String>();
                LinkedHashMap<DefaultBindable, String[]> map = new LinkedHashMap<DefaultBindable, String[]>();
                for (String name : queryString.getParameterNames()) {
                    List<String> paramValues = Arrays.asList(queryString.getParameterValues(name));
                    DefaultBindable tempBindable = new DefaultBindable();
                    tempBindable.bindsTo(Evaluation.property(name));
                    for (String value : paramValues) {
                        if (!pattern.matcher(value).matches()) continue;
                        Maps.addArrayValue(map, tempBindable, value);
                        values.add(value);
                    }
                }
                map.put(this.bindable, values.toArray(new String[0]));
                if (!values.isEmpty()) {
                    return Bindings.enqueuePreOperationSubmissions(event, context, map);
                }
                return false;
            }
        };
    }
}

