/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.ocpsoft.common.util.Streams;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.servlet.RewriteLifecycleContext;
import org.ocpsoft.rewrite.servlet.config.OutputBuffer;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.impl.HttpOutboundRewriteImpl;
import org.ocpsoft.rewrite.servlet.spi.RewriteLifecycleListener;
import org.ocpsoft.rewrite.spi.RewriteProvider;

public class HttpRewriteWrappedResponse
extends HttpServletResponseWrapper {
    private final HttpServletRequest request;
    private static final String INSTANCE_KEY = HttpRewriteWrappedResponse.class.getName() + "_instance";
    private ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.stream, Charset.forName(this.getCharacterEncoding())), true);
    private List<OutputBuffer> bufferedStages = new ArrayList<OutputBuffer>();
    private boolean buffersLocked = false;

    public static HttpRewriteWrappedResponse getInstance(HttpServletRequest request) {
        return (HttpRewriteWrappedResponse)((Object)request.getAttribute(INSTANCE_KEY));
    }

    public HttpRewriteWrappedResponse(HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this.request = request;
        if (HttpRewriteWrappedResponse.getInstance(request) == null) {
            request.setAttribute(INSTANCE_KEY, (Object)this);
        }
    }

    public boolean isBufferingActive() {
        return !this.bufferedStages.isEmpty();
    }

    public void addBufferStage(OutputBuffer stage) throws IllegalStateException {
        if (this.areBuffersLocked()) {
            throw new IllegalStateException("Cannot add output buffers to Response once request processing has been passed to the application.");
        }
        this.bufferedStages.add(stage);
    }

    private boolean areBuffersLocked() {
        return this.buffersLocked;
    }

    private void lockBuffers() {
        this.buffersLocked = true;
    }

    public void flushBufferedStreams() {
        if (this.isBufferingActive()) {
            try {
                InputStream result = new ByteArrayInputStream(this.stream.toByteArray());
                for (OutputBuffer stage : this.bufferedStages) {
                    result = stage.execute(result);
                }
                Streams.copy(result, (OutputStream)super.getOutputStream());
                if (this.printWriter != null) {
                    this.printWriter.close();
                }
                if (this.stream != null) {
                    this.stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        if (this.isBufferingActive()) {
            try {
                return this.stream.toString(this.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new RewriteException("Response accepted invalid character encoding " + this.getCharacterEncoding(), e);
            }
        }
        return super.toString();
    }

    public PrintWriter getWriter() {
        if (this.isBufferingActive()) {
            return this.printWriter;
        }
        try {
            this.lockBuffers();
            return super.getWriter();
        }
        catch (IOException e) {
            throw new RewriteException(e);
        }
    }

    public ServletOutputStream getOutputStream() {
        if (this.isBufferingActive()) {
            return new ByteArrayServletOutputStream(this.stream);
        }
        try {
            this.lockBuffers();
            return super.getOutputStream();
        }
        catch (IOException e) {
            throw new RewriteException(e);
        }
    }

    public void setContentLength(int contentLength) {
        this.lockBuffers();
        if (!this.isBufferingActive()) {
            super.setContentLength(contentLength);
        }
    }

    public void flushBuffer() throws IOException {
        if (this.isBufferingActive()) {
            this.stream.flush();
        } else {
            this.lockBuffers();
            super.flushBuffer();
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        HttpOutboundRewriteImpl event = new HttpOutboundRewriteImpl(this.request, (HttpServletResponse)this, url);
        this.rewrite(event);
        if (event.getFlow().is(BaseRewrite.Flow.ABORT_REQUEST)) {
            return event.getOutboundURL();
        }
        return super.encodeRedirectURL(event.getOutboundURL());
    }

    public String encodeURL(String url) {
        HttpOutboundRewriteImpl event = new HttpOutboundRewriteImpl(this.request, (HttpServletResponse)this, url);
        this.rewrite(event);
        if (event.getFlow().is(BaseRewrite.Flow.ABORT_REQUEST)) {
            return event.getOutboundURL();
        }
        return super.encodeURL(event.getOutboundURL());
    }

    private void rewrite(HttpOutboundServletRewrite event) {
        RewriteLifecycleContext context = (RewriteLifecycleContext)this.request.getAttribute("_com.ocpsoft.rewrite.RequestContext");
        for (RewriteLifecycleListener<Rewrite> rewriteLifecycleListener : context.getRewriteLifecycleListeners()) {
            rewriteLifecycleListener.beforeOutboundRewrite(event);
        }
        for (RewriteProvider rewriteProvider : context.getRewriteProviders()) {
            if (!rewriteProvider.handles(event)) continue;
            rewriteProvider.rewrite(event);
            if (!event.getFlow().is(BaseRewrite.Flow.HANDLED)) continue;
            break;
        }
        for (RewriteLifecycleListener rewriteLifecycleListener : context.getRewriteLifecycleListeners()) {
            rewriteLifecycleListener.afterOutboundRewrite(event);
        }
    }

    public void addCookie(Cookie cookie) {
        this.lockBuffers();
        super.addCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return super.containsHeader(name);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.lockBuffers();
        super.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.lockBuffers();
        super.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.lockBuffers();
        super.sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        this.lockBuffers();
        super.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.lockBuffers();
        super.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.lockBuffers();
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.lockBuffers();
        super.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.lockBuffers();
        super.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.lockBuffers();
        super.addIntHeader(name, value);
    }

    public void setStatus(int sc) {
        this.lockBuffers();
        super.setStatus(sc);
    }

    public void setStatus(int sc, String sm) {
        this.lockBuffers();
        super.setStatus(sc, sm);
    }

    public int getStatus() {
        return super.getStatus();
    }

    public String getHeader(String name) {
        return super.getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        return super.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return super.getHeaderNames();
    }

    public ServletResponse getResponse() {
        return super.getResponse();
    }

    public void setResponse(ServletResponse response) {
        super.setResponse(response);
    }

    public void setCharacterEncoding(String charset) {
        this.lockBuffers();
        super.setCharacterEncoding(charset);
    }

    public String getCharacterEncoding() {
        return super.getCharacterEncoding();
    }

    public void setBufferSize(int size) {
        super.setBufferSize(size);
    }

    public int getBufferSize() {
        return super.getBufferSize();
    }

    public boolean isCommitted() {
        return super.isCommitted();
    }

    public void reset() {
        this.stream.reset();
        super.reset();
    }

    public void resetBuffer() {
        this.stream.reset();
        super.resetBuffer();
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
    }

    public Locale getLocale() {
        return super.getLocale();
    }

    private class ByteArrayServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream outputStream;

        public ByteArrayServletOutputStream(ByteArrayOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void write(int b) {
            this.outputStream.write(b);
        }

        public void write(byte[] bytes) throws IOException {
            this.outputStream.write(bytes);
        }

        public void write(byte[] bytes, int off, int len) {
            this.outputStream.write(bytes, off, len);
        }
    }
}

