/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation.handler;

import java.lang.reflect.Field;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.annotation.Parameter;
import org.ocpsoft.rewrite.annotation.api.FieldContext;
import org.ocpsoft.rewrite.annotation.api.HandlerChain;
import org.ocpsoft.rewrite.annotation.spi.FieldAnnotationHandler;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.Or;
import org.ocpsoft.rewrite.config.True;
import org.ocpsoft.rewrite.config.Visitor;
import org.ocpsoft.rewrite.el.El;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.servlet.config.IRequestParameter;
import org.ocpsoft.rewrite.servlet.config.RequestParameter;

public class ParameterHandler
extends FieldAnnotationHandler<Parameter> {
    private final Logger log = Logger.getLogger(ParameterHandler.class);

    public Class<Parameter> handles() {
        return Parameter.class;
    }

    public int priority() {
        return 100;
    }

    public void process(FieldContext context, Parameter annotation, HandlerChain chain) {
        Field field = context.getJavaField();
        String param = field.getName();
        if (!annotation.value().isEmpty()) {
            param = annotation.value().trim();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Binding parameter [{}] to field [{}]", (Object)param, (Object)field);
        }
        AddBindingVisitor visitor = new AddBindingVisitor(context, chain, param, field);
        context.getRuleBuilder().accept((Visitor)visitor);
        if (!visitor.isFound()) {
            IRequestParameter.IRequestParameterParameter requestParameter = RequestParameter.matches((String)"{name}", (String)("{" + param + "}")).where("name").matches(param);
            ConditionBuilder composite = context.getRuleBuilder().getConditionBuilder().and((Condition)Or.any((Condition[])new Condition[]{requestParameter, True.create()}));
            context.getRuleBuilder().when((Condition)composite);
            AddBindingVisitor fallback = new AddBindingVisitor(context, chain, param, field);
            context.getRuleBuilder().accept((Visitor)fallback);
            Assert.assertTrue((boolean)fallback.isFound(), (String)("The parameter [" + param + "] bound to Field [" + field.getDeclaringClass().getName() + "." + field.getName() + "] was not found in any condition."));
        }
        chain.proceed();
    }

    private static class AddBindingVisitor
    implements Visitor<Condition> {
        private final Logger log = Logger.getLogger(AddBindingVisitor.class);
        private final String param;
        private final FieldContext context;
        private final Field field;
        private final HandlerChain chain;
        private boolean found = false;

        public AddBindingVisitor(FieldContext context, HandlerChain chain, String paramName, Field field) {
            this.context = context;
            this.chain = chain;
            this.param = paramName;
            this.field = field;
        }

        public void visit(Condition condition) {
            if (condition instanceof Parameterized) {
                org.ocpsoft.rewrite.param.Parameter parameter;
                Parameterized parameterized;
                block5: {
                    parameterized = (Parameterized)condition;
                    parameter = null;
                    try {
                        parameter = parameterized.where(this.param);
                    }
                    catch (IllegalArgumentException e) {
                        if (!this.log.isTraceEnabled()) break block5;
                        this.log.trace("Parameter [{}] not found on: {}", (Object)this.param, (Object)parameterized.getClass().getSimpleName());
                    }
                }
                if (parameter != null) {
                    Assert.assertFalse((boolean)this.found, (String)("It seems like the parameter [" + this.param + "] is present in more than one condition. That is currently not supported!"));
                    this.found = true;
                    this.context.put(org.ocpsoft.rewrite.param.Parameter.class, (Object)parameter);
                    El rawBinding = El.property((Field)this.field);
                    this.context.put(Binding.class, (Object)rawBinding);
                    this.chain.proceed();
                    Binding enrichedBinding = (Binding)this.context.get(Binding.class);
                    Assert.notNull((Object)enrichedBinding, (String)"BindingBuilder was removed from the context");
                    parameter.bindsTo(enrichedBinding);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Added binding for parameter [{}] to: {}", (Object)this.param, (Object)parameterized.getClass().getSimpleName());
                    }
                }
            }
        }

        public boolean isFound() {
            return this.found;
        }
    }
}

