/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config.typesafe;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.spi.InstanceProvider;
import org.ocpsoft.rewrite.typesafe.net.sf.cglib.proxy.Enhancer;
import org.ocpsoft.rewrite.typesafe.net.sf.cglib.proxy.MethodInterceptor;
import org.ocpsoft.rewrite.typesafe.net.sf.cglib.proxy.MethodProxy;
import org.ocpsoft.rewrite.util.Instances;

public class Typesafe
implements Operation {
    private final List<String> parameters = new ArrayList<String>();
    private Method method;
    private Object[] args;

    public static Typesafe method() {
        return new Typesafe();
    }

    public <T> T invoke(Class<T> type) {
        try {
            Object o = Enhancer.create(type, new RouteMethodInterceptor(this));
            return (T)o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void perform(Rewrite event, EvaluationContext context) {
        this.performInvoke(this.buildArguments(event, context));
    }

    public Object[] buildArguments(Rewrite event, EvaluationContext context) {
        Class<?> type = this.method.getDeclaringClass();
        if (this.parameters.size() != this.args.length) {
            throw new IllegalStateException("Invalid number of parameters specified in " + Typesafe.class.getSimpleName() + " method invocation [" + this.buildSignature(type, this.method) + "]. Expected [" + this.args.length + "] but got [" + this.parameters.size() + "]");
        }
        Object[] values = new Object[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            String arg = this.parameters.get(i);
            values[i] = arg != null ? Evaluation.property((CharSequence)arg).retrieveConverted(event, context) : this.args[i];
        }
        return values;
    }

    public Object performInvoke(Object[] values) {
        Class<?> type = this.method.getDeclaringClass();
        if (values.length != this.args.length) {
            throw new IllegalStateException("Invalid number of parameters provided in " + Typesafe.class.getSimpleName() + " method invocation [" + this.buildSignature(type, this.method) + "]. Expected [" + this.args.length + "] but got [" + values.length + "]");
        }
        Object instance = Instances.lookup(type);
        if (instance == null) {
            throw new IllegalStateException("Cannot invoke method [" + this.buildSignature(type, this.method) + "] because no instance of type [" + type.getName() + "] could be provided by any configured " + InstanceProvider.class.getSimpleName());
        }
        try {
            return this.method.invoke(instance, values);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T param(Class<T> type) {
        return this.param(type, null);
    }

    public <T> T param(Class<T> type, String name) {
        Comparable<Boolean> result = null;
        if (type != null && Boolean.TYPE.isAssignableFrom(type)) {
            result = Boolean.FALSE;
        }
        if (type != null && Byte.TYPE.isAssignableFrom(type)) {
            result = new Byte("0");
        }
        if (type != null && Character.TYPE.isAssignableFrom(type)) {
            result = new Character('0');
        }
        if (type != null && Double.TYPE.isAssignableFrom(type)) {
            result = new Double(0.0);
        }
        if (type != null && Float.TYPE.isAssignableFrom(type)) {
            result = new Float(0.0f);
        }
        if (type != null && Integer.TYPE.isAssignableFrom(type)) {
            result = new Integer(0);
        }
        if (type != null && Long.TYPE.isAssignableFrom(type)) {
            result = new Long(0L);
        }
        if (type != null && Short.TYPE.isAssignableFrom(type)) {
            result = new Short("0");
        }
        this.parameters.add(name);
        return (T)result;
    }

    private String buildSignature(Class<?> type, Method method2) {
        String result = type.getSimpleName() + "." + this.method.getName();
        result = result + "(";
        Class<?>[] types = this.method.getParameterTypes();
        boolean first = true;
        for (Class<?> paramType : types) {
            if (!first) {
                result = result + ", ";
            }
            result = result + paramType.getSimpleName();
            first = false;
        }
        result = result + ")";
        return result;
    }

    public Method getMethod() {
        return this.method;
    }

    static /* synthetic */ Object[] access$102(Typesafe x0, Object[] x1) {
        x0.args = x1;
        return x1;
    }

    private static class RouteMethodInterceptor
    implements MethodInterceptor {
        private final Typesafe typesafe;

        public RouteMethodInterceptor(Typesafe typesafe) {
            this.typesafe = typesafe;
        }

        @Override
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            this.typesafe.method = method;
            Typesafe.access$102(this.typesafe, args);
            return null;
        }
    }
}

