/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.bind.DefaultBindable;
import org.ocpsoft.rewrite.bind.HasConverter;
import org.ocpsoft.rewrite.bind.HasValidator;
import org.ocpsoft.rewrite.bind.Validator;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constrainable;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.Transform;
import org.ocpsoft.rewrite.param.Transformable;
import org.ocpsoft.rewrite.util.ValueHolderUtil;

public abstract class ParameterBuilder<PARAMTYPE extends ParameterBuilder<PARAMTYPE, VALUETYPE>, VALUETYPE>
extends DefaultBindable<PARAMTYPE>
implements Parameter<PARAMTYPE, VALUETYPE> {
    private final List<Transform<VALUETYPE>> transforms = new ArrayList<Transform<VALUETYPE>>();
    private final List<Constraint<VALUETYPE>> constraints = new ArrayList<Constraint<VALUETYPE>>();
    private Converter<?> converter = null;
    private Validator<?> validator = null;
    private List<Object> delegates = new ArrayList<Object>(0);

    public ParameterBuilder() {
    }

    public ParameterBuilder(Object ... delegates) {
        this.delegates = Arrays.asList(delegates);
    }

    @Override
    public Object convert(Rewrite event, EvaluationContext context, Object value) {
        return ValueHolderUtil.convert(event, context, this.converter, value);
    }

    @Override
    public boolean validate(Rewrite event, EvaluationContext context, Object value) {
        return ValueHolderUtil.validates(event, context, this.validator, value);
    }

    @Override
    public PARAMTYPE bindsTo(Binding binding) {
        if (binding instanceof HasConverter && this.converter != null) {
            ((HasConverter)((Object)binding)).convertedBy(this.converter);
        }
        if (binding instanceof HasValidator && this.validator != null) {
            ((HasValidator)((Object)binding)).validatedBy(this.validator);
        }
        for (Object delegate : this.delegates) {
            if (!(delegate instanceof Bindable)) continue;
            ((Bindable)delegate).bindsTo(binding);
        }
        return (PARAMTYPE)((ParameterBuilder)super.bindsTo(binding));
    }

    @Override
    public <X extends Converter<?>> PARAMTYPE convertedBy(Class<X> type) {
        this.converter = ValueHolderUtil.resolveConverter(type);
        for (Binding binding : this.getBindings()) {
            if (!(binding instanceof HasConverter)) continue;
            ((HasConverter)((Object)binding)).convertedBy(this.converter);
        }
        for (Object delegate : this.delegates) {
            if (!(delegate instanceof Bindable)) continue;
            Bindable bindable = (Bindable)delegate;
            for (Binding binding : bindable.getBindings()) {
                if (!(binding instanceof HasConverter)) continue;
                ((HasConverter)((Object)binding)).convertedBy(this.converter);
            }
        }
        return (PARAMTYPE)this;
    }

    @Override
    public PARAMTYPE convertedBy(Converter<?> converter) {
        this.converter = converter;
        for (Binding binding : this.getBindings()) {
            if (!(binding instanceof HasConverter)) continue;
            ((HasConverter)((Object)binding)).convertedBy(converter);
        }
        for (Object delegate : this.delegates) {
            if (!(delegate instanceof Bindable)) continue;
            Bindable bindable = (Bindable)delegate;
            for (Binding binding : bindable.getBindings()) {
                if (!(binding instanceof HasConverter)) continue;
                ((HasConverter)((Object)binding)).convertedBy(converter);
            }
        }
        return (PARAMTYPE)this;
    }

    @Override
    public Converter<?> getConverter() {
        return this.converter;
    }

    @Override
    public <X extends Validator<?>> PARAMTYPE validatedBy(Class<X> type) {
        this.validator = ValueHolderUtil.resolveValidator(type);
        for (Binding binding : this.getBindings()) {
            if (!(binding instanceof HasValidator)) continue;
            ((HasValidator)((Object)binding)).validatedBy(this.validator);
        }
        for (Object delegate : this.delegates) {
            if (!(delegate instanceof Bindable)) continue;
            Bindable bindable = (Bindable)delegate;
            for (Binding binding : bindable.getBindings()) {
                if (!(binding instanceof HasValidator)) continue;
                ((HasValidator)((Object)binding)).validatedBy(this.validator);
            }
        }
        return (PARAMTYPE)this;
    }

    @Override
    public PARAMTYPE validatedBy(Validator<?> validator) {
        this.validator = validator;
        for (Binding binding : this.getBindings()) {
            if (!(binding instanceof HasValidator)) continue;
            ((HasValidator)((Object)binding)).validatedBy(validator);
        }
        for (Object delegate : this.delegates) {
            if (!(delegate instanceof Bindable)) continue;
            Bindable bindable = (Bindable)delegate;
            for (Binding binding : bindable.getBindings()) {
                if (!(binding instanceof HasValidator)) continue;
                ((HasValidator)((Object)binding)).validatedBy(validator);
            }
        }
        return (PARAMTYPE)this;
    }

    @Override
    public Validator<?> getValidator() {
        return this.validator;
    }

    @Override
    public PARAMTYPE constrainedBy(Constraint<VALUETYPE> constraint) {
        this.constraints.add(constraint);
        for (Object delegate : this.delegates) {
            if (!(delegate instanceof Constrainable)) continue;
            ((Constrainable)delegate).constrainedBy(constraint);
        }
        return (PARAMTYPE)this;
    }

    @Override
    public List<Constraint<VALUETYPE>> getConstraints() {
        return this.constraints;
    }

    @Override
    public PARAMTYPE transformedBy(Transform<VALUETYPE> transform) {
        this.transforms.add(transform);
        for (Object delegate : this.delegates) {
            if (!(delegate instanceof Transformable)) continue;
            ((Transformable)delegate).transformedBy(transform);
        }
        return (PARAMTYPE)this;
    }

    @Override
    public List<Transform<VALUETYPE>> getTransforms() {
        return this.transforms;
    }

    @Override
    public String toString() {
        return "ParameterBuilder [transforms=" + this.transforms + ", constraints=" + this.constraints + ", bindings=" + this.getBindings() + ", converter=" + this.converter + ", validator=" + this.validator + "]";
    }
}

