/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternParserParameter;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IDomain;
import org.ocpsoft.rewrite.servlet.config.bind.Request;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Hostname
extends HttpCondition
implements IDomain {
    private final ParameterizedPatternParser expression;
    private final ParameterStore<IDomain.DomainParameter> parameters = new ParameterStore();

    private Hostname(String pattern) {
        Assert.notNull(pattern, "Domain must not be null.");
        this.expression = new RegexParameterizedPatternParser(pattern);
    }

    public static Hostname matches(String pattern) {
        return new Hostname(pattern);
    }

    @Override
    public IDomain.DomainParameter where(String param) {
        return this.parameters.where(param, new IDomain.DomainParameter(this, (ParameterizedPatternParserParameter)this.expression.getParameter(param)));
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String hostName = null;
        if (event instanceof HttpOutboundServletRewrite) {
            hostName = event.getAddress().getHost();
            if (hostName == null) {
                hostName = ((HttpServletRequest)event.getRequest()).getServerName();
            }
        } else {
            hostName = ((HttpServletRequest)event.getRequest()).getServerName();
        }
        if (hostName != null && this.expression.matches(event, context, hostName)) {
            Map<ParameterizedPatternParserParameter, String[]> parameters = this.expression.parse(event, context, hostName);
            for (ParameterizedPatternParserParameter parameter : this.expression.getParameterMap().values()) {
                this.where(parameter.getName()).bindsTo(Evaluation.property(parameter.getName()));
            }
            for (ParameterizedPatternParserParameter capture : parameters.keySet()) {
                if (Bindings.enqueueSubmission(event, context, this.where(capture.getName()), parameters.get(capture))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ParameterizedPatternParser getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public IDomain withRequestBinding() {
        for (ParameterizedPatternParserParameter parameter : this.expression.getParameterMap().values()) {
            this.where(parameter.getName()).bindsTo(Request.parameter(parameter.getName()));
        }
        return this;
    }

    @Override
    public ParameterizedPatternParser getDomainExpression() {
        return this.expression;
    }
}

