/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.net.MalformedURLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternParserParameter;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IResource;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Resource
extends HttpCondition
implements IResource {
    private static final Logger log = Logger.getLogger(Resource.class);
    private final ParameterizedPatternParser resource;
    private final ParameterStore<IResource.ResourceParameter> parameters = new ParameterStore();

    private Resource(String resource) {
        this.resource = new RegexParameterizedPatternParser(resource);
        for (ParameterizedPatternParserParameter parameter : this.resource.getParameterMap().values()) {
            this.where(parameter.getName()).bindsTo(Evaluation.property(parameter.getName()));
        }
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        if (this.resource != null) {
            String file = this.resource.getBuilder().build(event, context, this.parameters);
            try {
                if (((HttpServletRequest)event.getRequest()).getServletContext().getResource(file) != null) {
                    Map<ParameterizedPatternParserParameter, String[]> parameters = this.resource.parse(event, context, file);
                    for (ParameterizedPatternParserParameter capture : parameters.keySet()) {
                        if (Bindings.enqueueSubmission(event, context, this.where(capture.getName()), parameters.get(capture))) continue;
                        return false;
                    }
                    return true;
                }
            }
            catch (MalformedURLException e) {
                log.debug("Invalid file format [{}]", file);
            }
        }
        return false;
    }

    public static Resource exists(String resource) {
        return new Resource(resource);
    }

    @Override
    public IResource.ResourceParameter where(String param) {
        return this.parameters.where(param, new IResource.ResourceParameter(this, (ParameterizedPatternParserParameter)this.resource.getParameter(param)));
    }

    @Override
    public ParameterizedPatternParser getResourceExpression() {
        return this.resource;
    }
}

