/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.bind;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.rewrite.bind.BindingBuilder;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.bind.Validator;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.RewriteWrappedRequest;
import org.ocpsoft.rewrite.servlet.event.ServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.util.Maps;

public abstract class Request
extends BindingBuilder<Request, String> {
    public static Request attribute(String property) {
        return new RequestAttributeBinding(property);
    }

    public static Request attribute(String property, Class<? extends Converter<?>> type) {
        return (Request)Request.attribute(property).convertedBy(type);
    }

    public static Request attribute(String property, Class<Converter<?>> converterType, Class<? extends Validator<?>> validatorType) {
        return (Request)Request.attribute(property, converterType).validatedBy(validatorType);
    }

    public static Request parameter(String property) {
        return new RequestParameterBinding(property);
    }

    public static Request parameter(String property, Class<? extends Converter<?>> type) {
        return (Request)Request.parameter(property).convertedBy(type);
    }

    public static Request parameter(String property, Class<Converter<?>> converterType, Class<? extends Validator<?>> validatorType) {
        return (Request)Request.parameter(property, converterType).validatedBy(validatorType);
    }

    @Override
    public boolean supportsRetrieval() {
        return true;
    }

    @Override
    public boolean supportsSubmission() {
        return true;
    }

    private static class RequestAttributeBinding
    extends Request {
        private final String parameter;

        public RequestAttributeBinding(String attribute) {
            this.parameter = attribute;
        }

        @Override
        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).setAttribute(this.parameter, value);
            return null;
        }

        @Override
        public Object retrieve(Rewrite event, EvaluationContext context) {
            if (event instanceof HttpServletRewrite) {
                return ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).getParameter(this.parameter);
            }
            return null;
        }

        public String toString() {
            return "RequestAttributeBinding [parameter=" + this.parameter + "]";
        }
    }

    private static class RequestParameterBinding
    extends Request {
        private final String parameter;

        public RequestParameterBinding(String parameter) {
            this.parameter = parameter;
        }

        @Override
        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            Object request = ((ServletRewrite)event).getRequest();
            RewriteWrappedRequest wrapper = RewriteWrappedRequest.getCurrentInstance(request);
            Map<String, String[]> modifiableParameters = wrapper.getModifiableParameters();
            if (value.getClass().isArray()) {
                Object[] values;
                for (Object object : values = (Object[])value) {
                    Maps.addArrayValue(modifiableParameters, this.parameter, object.toString());
                }
            } else {
                Maps.addArrayValue(modifiableParameters, this.parameter, value.toString());
            }
            return null;
        }

        @Override
        public Object retrieve(Rewrite event, EvaluationContext context) {
            return ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).getParameter(this.parameter);
        }

        public String toString() {
            return "RequestParameterBinding [parameter=" + this.parameter + "]";
        }
    }
}

