/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Hostname
extends HttpCondition
implements Parameterized {
    private final ParameterizedPatternParser expression;

    private Hostname(String pattern) {
        Assert.notNull(pattern, "Domain must not be null.");
        this.expression = new RegexParameterizedPatternParser(pattern);
    }

    public static Hostname matches(String pattern) {
        return new Hostname(pattern);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String hostName = null;
        if (event instanceof HttpOutboundServletRewrite) {
            hostName = event.getAddress().getHost();
            if (hostName == null) {
                hostName = ((HttpServletRequest)event.getRequest()).getServerName();
            }
        } else {
            hostName = ((HttpServletRequest)event.getRequest()).getServerName();
        }
        return hostName != null && this.expression.matches(event, context, hostName);
    }

    public ParameterizedPatternParser getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    public ParameterizedPatternParser getDomainExpression() {
        return this.expression;
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        return this.expression.getRequiredParameterNames();
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        this.expression.setParameterStore(store);
    }
}

