/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.util;

public class StringUtils {
    private static final char SLASH = '/';

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isNotBlank(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static boolean hasLeadingSlash(String s) {
        return s != null && StringUtils.isNotBlank(s) && '/' == s.charAt(0);
    }

    public static boolean hasTrailingSlash(String s) {
        return s != null && StringUtils.isNotBlank(s) && '/' == s.charAt(s.length() - 1);
    }

    public static String[] splitBySlash(String s) {
        if (s == null || StringUtils.isBlank(s)) {
            return new String[0];
        }
        char[] chars = s.toCharArray();
        int numberOfSegments = StringUtils.countSlashes(s) + 1;
        String[] segments = new String[numberOfSegments];
        int currentSegmentIndex = 0;
        int lastSlashIndex = -1;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '/') continue;
            segments[currentSegmentIndex] = new String(chars, lastSlashIndex + 1, i - lastSlashIndex - 1);
            ++currentSegmentIndex;
            lastSlashIndex = i;
        }
        segments[currentSegmentIndex] = lastSlashIndex + 1 < chars.length ? new String(chars, lastSlashIndex + 1, chars.length - lastSlashIndex - 1) : "";
        return segments;
    }

    public static int countSlashes(String s) {
        int result = 0;
        for (char ch : s.toCharArray()) {
            if (ch != '/') continue;
            ++result;
        }
        return result;
    }
}

