/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces.artifact;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.faces.util.NullComponent;
import org.ocpsoft.rewrite.spi.ConverterProvider;

public class FacesConverterProvider
implements ConverterProvider {
    public Converter<?> getByTargetType(Class<?> targetType) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Assert.notNull((Object)facesContext, (String)"FacesContext.getCurrentInstance() returned null. You should use @Deferred so the binding gets executed within the JSF lifecycle.");
        javax.faces.convert.Converter converter = facesContext.getApplication().createConverter(targetType);
        if (converter != null) {
            return FacesConverterAdapter.from(converter);
        }
        return null;
    }

    public Converter<?> getByConverterId(String id) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Assert.notNull((Object)facesContext, (String)"FacesContext.getCurrentInstance() returned null. You should use @Deferred so the binding gets executed within the JSF lifecycle.");
        javax.faces.convert.Converter converter = facesContext.getApplication().createConverter(id);
        if (converter != null) {
            return FacesConverterAdapter.from(converter);
        }
        return null;
    }

    public Converter<?> getByConverterType(Class<?> converterType) {
        return null;
    }

    public int priority() {
        return 0;
    }

    private static class FacesConverterAdapter<T>
    implements Converter<T> {
        private final javax.faces.convert.Converter converter;

        private FacesConverterAdapter(javax.faces.convert.Converter converter) {
            this.converter = converter;
        }

        public static <T> FacesConverterAdapter<T> from(javax.faces.convert.Converter converter) {
            return new FacesConverterAdapter<T>(converter);
        }

        public T convert(Rewrite event, EvaluationContext context, Object value) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Assert.notNull((Object)facesContext, (String)"FacesContext.getCurrentInstance() returned null. You should use @Deferred so the binding gets executed within the JSF lifecycle.");
            String valueAsString = value != null ? value.toString() : null;
            try {
                return (T)this.converter.getAsObject(facesContext, (UIComponent)new NullComponent(), valueAsString);
            }
            catch (ConverterException e) {
                return null;
            }
        }
    }
}

