/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.ArrayList;
import java.util.List;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.bind.DefaultBindable;
import org.ocpsoft.rewrite.bind.Validator;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.Transform;
import org.ocpsoft.rewrite.util.ValueHolderUtil;

public abstract class ParameterBuilder<IMPLTYPE extends ParameterBuilder<IMPLTYPE>>
extends DefaultBindable<IMPLTYPE>
implements Parameter<IMPLTYPE> {
    private final List<Transform<String>> transforms = new ArrayList<Transform<String>>();
    private final List<Constraint<String>> constraints = new ArrayList<Constraint<String>>();
    private Converter<?> converter = null;
    private Validator<?> validator = null;
    private String name;

    protected ParameterBuilder(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object convert(Rewrite event, EvaluationContext context, Object value) {
        return ValueHolderUtil.convert(event, context, this.converter, value);
    }

    @Override
    public boolean validate(Rewrite event, EvaluationContext context, Object value) {
        return ValueHolderUtil.validates(event, context, this.validator, value);
    }

    @Override
    public IMPLTYPE bindsTo(Binding binding) {
        return (IMPLTYPE)((ParameterBuilder)super.bindsTo(binding));
    }

    @Override
    public <X extends Converter<?>> IMPLTYPE convertedBy(Class<X> type) {
        this.converter = ValueHolderUtil.resolveConverter(type);
        return (IMPLTYPE)this;
    }

    @Override
    public IMPLTYPE convertedBy(Converter<?> converter) {
        this.converter = converter;
        return (IMPLTYPE)this;
    }

    @Override
    public Converter<?> getConverter() {
        return this.converter;
    }

    @Override
    public <X extends Validator<?>> IMPLTYPE validatedBy(Class<X> type) {
        this.validator = ValueHolderUtil.resolveValidator(type);
        return (IMPLTYPE)this;
    }

    @Override
    public IMPLTYPE validatedBy(Validator<?> validator) {
        this.validator = validator;
        return (IMPLTYPE)this;
    }

    @Override
    public Validator<?> getValidator() {
        return this.validator;
    }

    @Override
    public IMPLTYPE constrainedBy(Constraint<String> constraint) {
        this.constraints.add(constraint);
        return (IMPLTYPE)this;
    }

    @Override
    public List<Constraint<String>> getConstraints() {
        return this.constraints;
    }

    @Override
    public IMPLTYPE transformedBy(Transform<String> transform) {
        this.transforms.add(transform);
        return (IMPLTYPE)this;
    }

    @Override
    public List<Transform<String>> getTransforms() {
        return this.transforms;
    }

    @Override
    public String toString() {
        return "ParameterBuilder [" + this.name + " -> transforms=" + this.transforms + ", constraints=" + this.constraints + ", bindings=" + this.getBindings() + ", converter=" + this.converter + ", validator=" + this.validator + "]";
    }
}

