/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation.handler;

import java.lang.reflect.Field;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.annotation.Validate;
import org.ocpsoft.rewrite.annotation.api.FieldContext;
import org.ocpsoft.rewrite.annotation.api.HandlerChain;
import org.ocpsoft.rewrite.annotation.spi.FieldAnnotationHandler;
import org.ocpsoft.rewrite.bind.Validator;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.spi.ValidatorProvider;

public class ValidateHandler
extends FieldAnnotationHandler<Validate> {
    private final Logger log = Logger.getLogger(ValidateHandler.class);

    @Override
    public Class<Validate> handles() {
        return Validate.class;
    }

    @Override
    public int priority() {
        return 200;
    }

    @Override
    public void process(FieldContext context, Validate annotation, HandlerChain chain) {
        Field field = context.getJavaField();
        Parameter parameter = (Parameter)context.get(Parameter.class);
        if (parameter != null) {
            LazyValidatorAdapter validator = null;
            validator = annotation.with() != Object.class ? LazyValidatorAdapter.forValidatorType(annotation.with()) : (annotation.id().length() > 0 ? LazyValidatorAdapter.forValidatorId(annotation.id()) : LazyValidatorAdapter.forTargetType(field.getType()));
            parameter.validatedBy(validator);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Attached validator to field [{}] of class [{}]: ", new Object[]{field.getName(), field.getDeclaringClass().getName(), validator});
            }
        }
        chain.proceed();
    }

    private static class LazyValidatorAdapter
    implements Validator<Object> {
        private final Class<?> targetType;
        private final String validatorId;
        private final Class<?> validatorType;

        private LazyValidatorAdapter(Class<?> targetType, String validatorId, Class<?> validatorType) {
            this.targetType = targetType;
            this.validatorId = validatorId;
            this.validatorType = validatorType;
        }

        public static LazyValidatorAdapter forValidatorType(Class<?> validatorType) {
            return new LazyValidatorAdapter(null, null, validatorType);
        }

        public static LazyValidatorAdapter forValidatorId(String id) {
            return new LazyValidatorAdapter(null, id, null);
        }

        public static LazyValidatorAdapter forTargetType(Class<?> targetType) {
            return new LazyValidatorAdapter(targetType, null, null);
        }

        @Override
        public boolean validate(Rewrite event, EvaluationContext context, Object value) {
            Validator<?> validator = null;
            for (ValidatorProvider provider : ServiceLoader.load(ValidatorProvider.class)) {
                validator = this.targetType != null ? provider.getByTargetType(this.targetType) : (this.validatorType != null ? provider.getByValidatorType(this.validatorType) : provider.getByValidatorId(this.validatorId));
                if (validator == null) continue;
                break;
            }
            Assert.notNull(validator, "Got no validator from any ValidatorProvider for: " + this.toString());
            return validator.validate(event, context, value);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.getClass().getSimpleName());
            b.append(" for ");
            if (this.targetType != null) {
                b.append(" target type ");
                b.append(this.targetType.getName());
            } else if (this.validatorType != null) {
                b.append(" validator type ");
                b.append(this.validatorType.getName());
            } else {
                b.append(" id ");
                b.append(this.validatorId);
            }
            return b.toString();
        }
    }
}

