/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.ParameterizationException;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.param.Transform;
import org.ocpsoft.rewrite.util.ParseTools;

public class RegexParameterizedPatternBuilder
implements ParameterizedPatternBuilder {
    private static final String DEFAULT_PARAMETER_PATTERN = ".*";
    private final String pattern;
    private final char[] chars;
    private final List<RegexGroup> groups = new ArrayList<RegexGroup>();
    private final String defaultParameterPattern;
    private ParameterStore parameters;
    private RegexParameterizedPatternParser parser = null;

    RegexParameterizedPatternBuilder(String pattern, RegexParameterizedPatternParser parser) {
        this(pattern);
        this.parser = parser;
    }

    public RegexParameterizedPatternBuilder(String pattern) {
        this(ParseTools.CaptureType.BRACE, DEFAULT_PARAMETER_PATTERN, pattern);
    }

    public RegexParameterizedPatternBuilder(String parameterPattern, String pattern) {
        this(ParseTools.CaptureType.BRACE, parameterPattern, pattern);
    }

    public RegexParameterizedPatternBuilder(ParseTools.CaptureType type, String pattern) {
        this(type, DEFAULT_PARAMETER_PATTERN, pattern);
    }

    public RegexParameterizedPatternBuilder(ParseTools.CaptureType type, String defaultParameterPattern, String pattern) {
        Assert.notNull(pattern, "Pattern must not be null");
        this.defaultParameterPattern = defaultParameterPattern;
        this.pattern = pattern;
        this.chars = pattern.toCharArray();
        if (this.chars.length > 0) {
            int parameterIndex = 0;
            block3: for (int cursor = 0; cursor < this.chars.length; ++cursor) {
                switch (this.chars[cursor]) {
                    case '{': {
                        int startPos = cursor;
                        ParseTools.CapturingGroup group = ParseTools.balancedCapture(this.chars, startPos, this.chars.length - 1, type);
                        cursor = group.getEnd();
                        this.groups.add(new RegexGroup(group, parameterIndex++));
                        continue block3;
                    }
                }
            }
        }
    }

    @Override
    public String build(Rewrite event, EvaluationContext context, Transform<String> transform) throws ParameterizationException {
        return this.build(this.extractBoundValues(event, context, transform));
    }

    @Override
    public String build(List<Object> values) throws ParameterizationException {
        if (values == null && this.groups.size() != 0 || this.groups.size() != values.size()) {
            throw new ParameterizationException("Must supply [" + this.groups.size() + "] values to build output string.");
        }
        StringBuilder builder = new StringBuilder();
        ParseTools.CapturingGroup last = null;
        int index = 0;
        for (RegexGroup param : this.groups) {
            ParseTools.CapturingGroup capture = param.getCapture();
            if (last != null && last.getEnd() < capture.getStart()) {
                builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, capture.getStart()));
            } else if (last == null && capture.getStart() > 0) {
                builder.append(Arrays.copyOfRange(this.chars, 0, capture.getStart()));
            }
            builder.append(values.get(index++));
            last = capture;
        }
        if (last != null && last.getEnd() < this.chars.length) {
            builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, this.chars.length));
        } else if (last == null) {
            builder.append(this.chars);
        }
        String result = builder.toString();
        return result;
    }

    @Override
    public String build(Map<String, Object> values) throws ParameterizationException {
        if (values == null || this.groups.size() != values.size()) {
            throw new ParameterizationException("Must supply [" + this.groups.size() + "] values to build output string.");
        }
        StringBuilder builder = new StringBuilder();
        ParseTools.CapturingGroup last = null;
        for (RegexGroup param : this.groups) {
            ParseTools.CapturingGroup capture = param.getCapture();
            if (last != null && last.getEnd() < capture.getStart()) {
                builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, capture.getStart()));
            } else if (last == null && capture.getStart() > 0) {
                builder.append(Arrays.copyOfRange(this.chars, 0, capture.getStart()));
            }
            builder.append(values.get(param.getName()));
            last = capture;
        }
        if (last != null && last.getEnd() < this.chars.length) {
            builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, this.chars.length));
        } else if (last == null) {
            builder.append(this.chars);
        }
        String result = builder.toString();
        return result;
    }

    private Map<String, Object> extractBoundValues(Rewrite event, EvaluationContext context, Transform<String> transform) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (RegexGroup group : this.groups) {
            Parameter<?> parameter = this.parameters.get(group.getName());
            Object value = Bindings.performRetrieval(event, context, parameter);
            if (value == null && context.getState().isEvaluating()) {
                value = ((ParameterValueStore)context.get(ParameterValueStore.class)).retrieve(parameter);
            }
            if (value == null) {
                throw new ParameterizationException("Required parameter [" + group.getName() + "] value was null.");
            }
            result.put(group.getName(), transform.transform(event, context, value.toString()));
        }
        return result;
    }

    public String toString() {
        return new String(this.chars);
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public ParameterizedPatternParser getParser() {
        if (this.parser == null) {
            this.parser = new RegexParameterizedPatternParser(this, this.defaultParameterPattern, this.pattern);
            this.parser.setParameterStore(this.parameters);
        }
        return this.parser;
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        for (RegexGroup group : this.groups) {
            result.add(group.getName());
        }
        return result;
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        this.parameters = store;
    }

    class RegexGroup {
        private final ParseTools.CapturingGroup capture;
        private final int index;

        public RegexGroup(ParseTools.CapturingGroup capture, int index) {
            this.capture = capture;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return new String(this.capture.getCaptured());
        }

        public ParseTools.CapturingGroup getCapture() {
            return this.capture;
        }

        public String toString() {
            return "RegexParameter [name=" + this.getName() + ", capture=" + this.capture + "]";
        }
    }
}

