/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.InboundRewrite;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.QueryStringBuilder;
import org.ocpsoft.urlbuilder.Address;

public abstract class Query
extends HttpCondition
implements Parameterized {
    public static Query matches(final String query) {
        Assert.notNull(query, "URL pattern must not be null.");
        return new Query(){
            private ParameterStore store;
            final ParameterizedPatternParser pattern;
            {
                this.pattern = new RegexParameterizedPatternParser(query);
            }

            @Override
            public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
                String queryString = null;
                if (event instanceof InboundRewrite) {
                    queryString = event.getInboundAddress().getQuery();
                } else if (event instanceof HttpOutboundServletRewrite) {
                    queryString = ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).getQuery();
                }
                if (this.pattern.matches(event, context, queryString == null ? "" : queryString)) {
                    ParameterValueStore values = (ParameterValueStore)context.get(ParameterValueStore.class);
                    for (Map.Entry<Parameter<?>, String> entry : this.pattern.parse(event, context, query).entrySet()) {
                        values.submit(event, context, this.store.get(entry.getKey().getName()), entry.getValue());
                    }
                    return true;
                }
                return false;
            }

            public String toString() {
                return "Query.matches(" + query + ")";
            }

            @Override
            public Set<String> getRequiredParameterNames() {
                return this.pattern.getRequiredParameterNames();
            }

            @Override
            public void setParameterStore(ParameterStore store) {
                this.pattern.setParameterStore(store);
                this.store = store;
            }
        };
    }

    public static Query parameterExists(final String name) {
        Assert.notNull(name, "Parameter name pattern must not be null.");
        return new Query(){
            final ParameterizedPatternParser pattern;
            final String parameterName;
            {
                this.pattern = new RegexParameterizedPatternParser("{" + name + "}");
                this.parameterName = name;
            }

            @Override
            public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
                QueryStringBuilder queryString = QueryStringBuilder.createFromEncoded(event.getAddress().getQuery()).decode();
                for (String name2 : queryString.getParameterNames()) {
                    String[] parameterValues = queryString.getParameterValues(name2);
                    if (!this.parameterName.equals(name2)) continue;
                    if (parameterValues == null || parameterValues.length == 0) {
                        return this.pattern.matches("");
                    }
                    for (String value : parameterValues) {
                        if (!this.pattern.matches(value)) continue;
                        ParameterStore store = (ParameterStore)context.get(ParameterStore.class);
                        ParameterValueStore values = (ParameterValueStore)context.get(ParameterValueStore.class);
                        return values.submit(event, context, store.get(this.parameterName), value);
                    }
                }
                return false;
            }

            public String toString() {
                return "Query.parameterExists(" + name + ")";
            }

            @Override
            public Set<String> getRequiredParameterNames() {
                return this.pattern.getRequiredParameterNames();
            }

            @Override
            public void setParameterStore(ParameterStore store) {
                this.pattern.setParameterStore(store);
            }
        };
    }

    public static Query valueExists(final String valuePattern) {
        Assert.notNull(valuePattern, "Parameter value pattern must not be null.");
        return new Query(){
            final Pattern pattern;
            {
                this.pattern = Pattern.compile(valuePattern);
            }

            @Override
            public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
                QueryStringBuilder queryString = QueryStringBuilder.createFromEncoded(event.getAddress().getQuery()).decode();
                for (String name : queryString.getParameterNames()) {
                    for (String value : queryString.getParameterValues(name)) {
                        if (value == null || !this.pattern.matcher(value).matches()) continue;
                        return true;
                    }
                }
                return false;
            }

            public String toString() {
                return "Query.valueExists(" + valuePattern + ")";
            }

            @Override
            public Set<String> getRequiredParameterNames() {
                return Collections.emptySet();
            }

            @Override
            public void setParameterStore(ParameterStore store) {
            }
        };
    }
}

