/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces.navigate;

import java.util.List;
import java.util.Map;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.faces.navigate.ParameterMap;
import org.ocpsoft.rewrite.servlet.spi.ResourcePathResolver;
import org.ocpsoft.urlbuilder.AddressBuilder;
import org.ocpsoft.urlbuilder.AddressBuilderPath;

public class Navigate {
    private final String viewId;
    private final ParameterMap parameters = new ParameterMap();
    private boolean redirect = true;

    private Navigate(String viewId) {
        this.viewId = viewId;
    }

    public static Navigate to(String viewId) {
        Assert.notNull((Object)viewId, (String)"viewId must not be null");
        return new Navigate(viewId);
    }

    public static Navigate to(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        ServiceLoader resolvers = ServiceLoader.load(ResourcePathResolver.class);
        for (ResourcePathResolver resolver : resolvers) {
            String viewId = resolver.resolveFrom(clazz);
            if (viewId == null) continue;
            return new Navigate(viewId);
        }
        throw new IllegalArgumentException("Unable to find the resource path for: " + clazz.getName());
    }

    public Navigate with(CharSequence name, Object value) {
        Assert.notNull((Object)name, (String)"name must not be null");
        if (value != null) {
            this.parameters.put(((Object)name).toString(), value.toString());
        }
        return this;
    }

    public Navigate withoutRedirect() {
        this.redirect = false;
        return this;
    }

    public String build() {
        if (this.redirect) {
            return this.buildRedirectOutcome();
        }
        return this.buildStandardOutcome();
    }

    private String buildRedirectOutcome() {
        AddressBuilderPath builderPath = AddressBuilder.begin().path((CharSequence)this.viewId);
        for (Map.Entry<String, List<String>> param : this.parameters.entrySet()) {
            String[] values = param.getValue().toArray(new String[param.getValue().size()]);
            builderPath.query((CharSequence)param.getKey(), (Object[])values);
        }
        String url = builderPath.toString();
        return "rewrite-redirect:" + url;
    }

    private String buildStandardOutcome() {
        StringBuilder outcome = new StringBuilder();
        outcome.append(this.viewId);
        boolean first = true;
        for (Map.Entry<String, List<String>> param : this.parameters.entrySet()) {
            for (String value : param.getValue()) {
                outcome.append(first ? (char)'?' : '&');
                outcome.append(param.getKey());
                outcome.append('=');
                outcome.append(value);
                first = false;
            }
        }
        return outcome.toString();
    }

    public String toString() {
        return this.build();
    }
}

