/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.rewrite.el.spi.BeanNameResolver;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class LazyBeanNameFinder {
    private static final Log log = LogFactory.getLog(LazyBeanNameFinder.class);
    private final List<BeanNameResolver> resolvers = new ArrayList<BeanNameResolver>();

    public LazyBeanNameFinder(ServletContext servletContext) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        for (BeanNameResolver resolver : ServiceLoader.load(BeanNameResolver.class)) {
            if (log.isTraceEnabled()) {
                log.trace("Initializing BeanNameResolver: " + resolver.getClass().getName());
            }
            try {
                this.resolvers.add(resolver);
            }
            catch (ClassFormatError e) {
                log.warn("Failed to initialize " + resolver.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
    }

    public String findBeanName(Class<?> clazz) throws IllegalStateException {
        for (BeanNameResolver resolver : this.resolvers) {
            String name = resolver.getBeanName(clazz);
            if (name == null) continue;
            return name;
        }
        throw new IllegalStateException("Cannot find name of bean '" + clazz.getName() + "'! You should place a @URLBeanName annotation on this class to let PrettyFaces know its name.");
    }
}

