/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transform.less;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.ocpsoft.common.util.Streams;
import org.ocpsoft.rewrite.transform.StringTransformer;

public class Less
extends StringTransformer {
    private final String baseScript;

    public static Less compiler() {
        return new Less();
    }

    private Less() {
        StringBuilder scriptBuilder = new StringBuilder();
        scriptBuilder.append("function print(s) {}");
        scriptBuilder.append(Less.getClasspathResourceAsString("org/ocpsoft/rewrite/transform/js/env.rhino.1.2.js"));
        scriptBuilder.append(Less.getClasspathResourceAsString("org/ocpsoft/rewrite/transform/js/less-1.3.0.min.js"));
        scriptBuilder.append(Less.getClasspathResourceAsString("org/ocpsoft/rewrite/transform/js/api.js"));
        this.baseScript = scriptBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transform(String less) {
        Context context = Context.enter();
        try {
            context.setOptimizationLevel(-1);
            context.setLanguageVersion(160);
            ScriptableObject scope = context.initStandardObjects();
            String script = this.baseScript + "lessToCss('" + this.escape(less) + "');";
            Object result = context.evaluateString((Scriptable)scope, script, ((Object)((Object)this)).getClass().getSimpleName(), 1, null);
            if (result != null) {
                String string = result.toString();
                return string;
            }
        }
        finally {
            Context.exit();
        }
        return null;
    }

    private static String getClasspathResourceAsString(String resource) {
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (input == null) {
            throw new IllegalStateException("Could not find resource on the classpath: " + resource);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Streams.copy((InputStream)input, (OutputStream)output);
        return new String(output.toByteArray(), Charset.forName("UTF-8"));
    }

    private String escape(String s) {
        return s.replace("\r", "").replace("\n", "\\n");
    }
}

