/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.Retrieval;
import org.ocpsoft.rewrite.bind.Submission;
import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameter;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.spi.InvocationResultHandler;

public class Invoke
extends DefaultOperationBuilder {
    private static final Logger log = Logger.getLogger(Invoke.class);
    private final Submission submission;
    private final Retrieval retrieval;
    private final Parameter<?> parameter = new DefaultParameter("");

    private Invoke(Submission submission, Retrieval retrieval) {
        this.submission = submission;
        this.retrieval = retrieval;
    }

    @Override
    public void perform(Rewrite event, EvaluationContext context) {
        Object result = null;
        if (this.submission == null && this.retrieval != null) {
            result = this.retrieval.retrieve(event, context, this.parameter);
            log.debug("Invoked binding [" + this.retrieval + "] returned value [" + result + "]");
        } else if (this.retrieval != null) {
            result = this.submission.submit(event, context, this.parameter, this.retrieval.retrieve(event, context, this.parameter));
            log.debug("Invoked binding [" + this.submission + "] returned value [" + result + "]");
        } else {
            log.warn("No binding specified for Invocation.");
        }
        if (result != null) {
            ServiceLoader providers = ServiceLoader.load(InvocationResultHandler.class);
            if (!providers.iterator().hasNext()) {
                log.debug("No instances of [" + InvocationResultHandler.class.getName() + "] were registered to handing binding invocation result [" + result + "]");
            }
            for (InvocationResultHandler handler : providers) {
                handler.handle(event, context, result);
            }
        }
    }

    public static DefaultOperationBuilder binding(Retrieval retrieval) {
        return new Invoke(null, retrieval);
    }

    public static DefaultOperationBuilder binding(Submission to, Retrieval from) {
        return new Invoke(to, from);
    }
}

