/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class RequestParameter
extends HttpCondition
implements Parameterized {
    private final ParameterizedPatternParser name;
    private final ParameterizedPatternParser value;

    private RequestParameter(String name, String value) {
        Assert.notNull(name, "Header name pattern cannot be null.");
        Assert.notNull(value, "Header value pattern cannot be null.");
        this.name = new RegexParameterizedPatternParser(name);
        this.value = new RegexParameterizedPatternParser(value);
    }

    public static RequestParameter matches(String name, String value) {
        return new RequestParameter(name, value);
    }

    public static RequestParameter matchesAll(String name, String value) {
        return new AllRequestParameters(name, value);
    }

    public static RequestParameter exists(String name) {
        return new RequestParameter(name, "{" + RequestParameter.class.getName() + "_" + name + "_value}");
    }

    public static RequestParameter valueExists(String value) {
        return new RequestParameter("{" + RequestParameter.class.getName() + "_" + value + "_name}", value);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameter = parameterNames.nextElement().toString();
            if (!this.name.matches(event, context, parameter) || !this.matchesValue(event, context, request, parameter)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesValue(Rewrite event, EvaluationContext context, HttpServletRequest request, String parameterName) {
        for (String contents : Arrays.asList(request.getParameterValues(parameterName))) {
            if (!this.value.matches(event, context, contents)) continue;
            return true;
        }
        return false;
    }

    public ParameterizedPatternParser getNameExpression() {
        return this.name;
    }

    public ParameterizedPatternParser getValueExpression() {
        return this.value;
    }

    public String toString() {
        return "RequestParameter [name=" + this.name + ", value=" + this.value + "]";
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.name.getRequiredParameterNames());
        result.addAll(this.value.getRequiredParameterNames());
        return result;
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        this.name.setParameterStore(store);
        this.value.setParameterStore(store);
    }

    private static class AllRequestParameters
    extends RequestParameter {
        public AllRequestParameters(String name, String value) {
            super(name, value);
        }

        @Override
        public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
            HttpServletRequest request = (HttpServletRequest)event.getRequest();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String name = parameterNames.nextElement().toString();
                if (!this.getNameExpression().matches(event, context, name) || !this.matchesValues(event, context, request, name)) continue;
                return true;
            }
            return false;
        }

        private boolean matchesValues(Rewrite event, EvaluationContext context, HttpServletRequest request, String name) {
            for (String contents : Arrays.asList(request.getParameterValues(name))) {
                if (this.getValueExpression().matches(event, context, contents)) continue;
                return false;
            }
            return true;
        }
    }
}

