/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.response;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.servlet.config.response.ResponseStreamWrapper;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class GZipResponseStreamWrapper
implements ResponseStreamWrapper {
    @Override
    public OutputStream wrap(HttpServletRewrite rewrite, OutputStream outputStream) {
        ((HttpServletResponse)rewrite.getResponse()).addHeader("Content-Encoding", "gzip");
        try {
            FlushableGZIPOutputStream stream = new FlushableGZIPOutputStream(outputStream);
            return stream;
        }
        catch (IOException e) {
            throw new RewriteException("Could not wrap OutputStream", e);
        }
    }

    public class FlushableGZIPOutputStream
    extends GZIPOutputStream {
        public FlushableGZIPOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        public void flush() throws IOException {
            super.flush();
        }

        @Override
        public void close() throws IOException {
            this.finish();
            super.close();
        }
    }
}

