/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.spring;

import java.util.Map;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.el.spi.BeanNameResolver;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class SpringBeanNameResolver
implements BeanNameResolver {
    private final Logger log = Logger.getLogger(SpringBeanNameResolver.class);

    public String getBeanName(Class<?> clazz) {
        WebApplicationContext context = ContextLoader.getCurrentWebApplicationContext();
        if (context == null) {
            throw new IllegalStateException("Unable to get current WebApplicationContext");
        }
        Map beans = context.getBeansOfType(clazz);
        if (beans == null || beans.size() == 0) {
            return null;
        }
        if (beans.size() > 1) {
            this.log.warn("Spring knows more than one bean of type [{}]", (Object)clazz.getName());
            return null;
        }
        return (String)beans.keySet().iterator().next();
    }
}

