/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.bind;

import java.util.Arrays;
import java.util.List;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Parameter;

public class Evaluation
implements Binding {
    private final String property;

    private Evaluation(String property) {
        this.property = property;
    }

    public static Evaluation property(String property) {
        return new Evaluation(property);
    }

    @Override
    public Object submit(Rewrite event, EvaluationContext context, Object value) {
        String unconvertedName = this.getParameterUnconvertedName(this.property);
        if (!context.containsKey(this.property)) {
            if (value.getClass().isArray()) {
                this.storeValue(event, context, unconvertedName, value);
            } else {
                this.storeValue(event, context, unconvertedName, new Object[]{value});
            }
        } else {
            Object[] values = (Object[])context.get(unconvertedName);
            List<Object> list = Arrays.asList(values);
            if (value.getClass().isArray()) {
                list.addAll(Arrays.asList((Object[])value));
            } else {
                list.add(value);
            }
            this.storeValue(event, context, unconvertedName, list.toArray());
        }
        return null;
    }

    public Object submitConverted(Rewrite event, EvaluationContext context, Object value) {
        String convertedName = this.getParameterConvertedName(this.property);
        if (!context.containsKey(this.property)) {
            if (value.getClass().isArray()) {
                this.storeValue(event, context, convertedName, value);
            } else {
                this.storeValue(event, context, convertedName, new Object[]{value});
            }
        } else {
            Object[] values = (Object[])context.get(convertedName);
            List<Object> list = Arrays.asList(values);
            if (value.getClass().isArray()) {
                list.addAll(Arrays.asList((Object[])value));
            } else {
                list.add(value);
            }
            this.storeValue(event, context, convertedName, list.toArray());
        }
        return null;
    }

    private void storeValue(Rewrite event, EvaluationContext context, String key, Object value) {
        context.put(key, value);
    }

    public boolean hasValue(Rewrite event, EvaluationContext context) {
        return context.get(this.getParameterUnconvertedName(this.property)) != null;
    }

    private String getParameterUnconvertedName(String parameter) {
        return Evaluation.class.getName() + "_" + parameter;
    }

    private String getParameterConvertedName(String parameter) {
        return this.getParameterUnconvertedName(parameter) + "_converted";
    }

    @Override
    public Object retrieve(Rewrite event, EvaluationContext context) {
        return this.retrieveFromProperty(context, this.getParameterUnconvertedName(this.property));
    }

    public Object retrieveConverted(Rewrite inbound, EvaluationContext context, Parameter<?> parameter) {
        return this.retrieveFromProperty(context, this.getParameterConvertedName(this.property));
    }

    private Object retrieveFromProperty(EvaluationContext context, String propertyName) {
        Object[] values;
        Object object = context.get(propertyName);
        if (object == null) {
            throw new IllegalArgumentException("Attempted to access the non-existent " + this.converted(propertyName) + " EvaluationContext property \"{" + this.removePropertyNamespace(propertyName) + "}\"");
        }
        if (object.getClass().isArray() && (values = (Object[])object).length == 1) {
            return values[0];
        }
        return object;
    }

    private String converted(String propertyName) {
        return propertyName.endsWith("_converted") ? "converted" : "";
    }

    private String removePropertyNamespace(String propertyName) {
        String result = propertyName;
        if (propertyName.startsWith(this.getClass().getName())) {
            result = result.substring(this.getClass().getName().length() + 1);
        }
        if (result.endsWith("_converted")) {
            result = result.substring(0, result.length() - "_converted".length() - 1);
        }
        return result;
    }

    @Override
    public boolean supportsRetrieval() {
        return true;
    }

    @Override
    public boolean supportsSubmission() {
        return true;
    }

    public String toString() {
        return "Evaluation [property=" + this.property + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Evaluation other = (Evaluation)obj;
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }
}

