/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.urlbuilder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilderAnchor;
import org.ocpsoft.urlbuilder.AddressBuilderBase;
import org.ocpsoft.urlbuilder.AddressBuilderDomain;
import org.ocpsoft.urlbuilder.AddressBuilderPath;
import org.ocpsoft.urlbuilder.AddressBuilderPort;
import org.ocpsoft.urlbuilder.AddressBuilderQuery;
import org.ocpsoft.urlbuilder.AddressBuilderScheme;
import org.ocpsoft.urlbuilder.AddressResult;
import org.ocpsoft.urlbuilder.Parameter;
import org.ocpsoft.urlbuilder.util.Decoder;
import org.ocpsoft.urlbuilder.util.Encoder;

public class AddressBuilder {
    private volatile Address address;
    protected volatile CharSequence scheme;
    protected volatile CharSequence domain;
    protected volatile Integer port;
    protected volatile CharSequence path;
    protected Map<CharSequence, Parameter> parameters = new LinkedHashMap<CharSequence, Parameter>();
    protected Map<CharSequence, Parameter> queries = new LinkedHashMap<CharSequence, Parameter>();
    protected CharSequence anchor;

    protected AddressBuilder() {
    }

    public static AddressBuilderBase begin() {
        return new AddressBuilderBase(new AddressBuilder());
    }

    protected Address build() {
        if (this.address == null) {
            this.address = new AddressResult(this);
        }
        return this.address;
    }

    public static Address create(String url) throws IllegalArgumentException {
        try {
            URI u = new URI(url);
            return AddressBuilder.begin().scheme(u.getScheme()).domain(u.getHost()).port(u.getPort()).pathEncoded(u.getRawPath()).queryLiteral(u.getRawQuery()).anchor(u.getRawFragment()).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("[" + url + "] is not a valid URL fragment. Consider encoding relevant portions of the URL with [" + Encoder.class + "]", e);
        }
    }

    AddressBuilderScheme scheme(CharSequence scheme) {
        this.scheme = scheme;
        return new AddressBuilderScheme(this);
    }

    AddressBuilderDomain domain(CharSequence domain) {
        this.domain = domain;
        return new AddressBuilderDomain(this);
    }

    AddressBuilderPort port(int port) {
        if (port >= 0) {
            this.port = port;
        }
        return new AddressBuilderPort(this);
    }

    AddressBuilderPath path(CharSequence path) {
        this.path = path;
        return new AddressBuilderPath(this);
    }

    AddressBuilderPath pathEncoded(CharSequence path) {
        this.path = Decoder.path(path);
        return new AddressBuilderPath(this);
    }

    AddressBuilderQuery query(CharSequence name, Object ... values) {
        this.queries.put(Encoder.query(((Object)name).toString()), Parameter.create((CharSequence)((Object)name).toString(), true, values));
        return new AddressBuilderQuery(this);
    }

    AddressBuilderQuery queryEncoded(CharSequence name, Object ... values) {
        this.queries.put(((Object)name).toString(), Parameter.create((CharSequence)((Object)name).toString(), false, values));
        return new AddressBuilderQuery(this);
    }

    AddressBuilderQuery queryLiteral(String query) {
        if (query != null) {
            if (query.startsWith("?")) {
                query = query.substring(1);
            }
            LinkedHashMap<String, ArrayList<String>> params = new LinkedHashMap<String, ArrayList<String>>();
            query = this.decodeHTMLAmpersands(query);
            int index = 0;
            while ((index = query.indexOf(38)) >= 0 || !query.isEmpty()) {
                String value;
                String name;
                int pos;
                String pair = query;
                if (index >= 0) {
                    pair = query.substring(0, index);
                    if (!(query = query.substring(index)).isEmpty()) {
                        query = query.substring(1);
                    }
                } else {
                    query = "";
                }
                if ((pos = pair.indexOf(61)) == -1) {
                    name = pair;
                    value = null;
                } else {
                    name = pair.substring(0, pos);
                    value = pair.substring(pos + 1, pair.length());
                }
                ArrayList<String> list = (ArrayList<String>)params.get(name);
                if (list == null) {
                    list = new ArrayList<String>();
                    params.put(name, list);
                }
                list.add(value);
            }
            for (Map.Entry entry : params.entrySet()) {
                this.queryEncoded((CharSequence)entry.getKey(), ((List)entry.getValue()).toArray());
            }
        }
        return new AddressBuilderQuery(this);
    }

    private String decodeHTMLAmpersands(String url) {
        if (url != null) {
            int index = 0;
            while ((index = url.indexOf("&amp;")) >= 0) {
                url = url.substring(0, index + 1) + url.substring(index + 5);
            }
        }
        return url;
    }

    AddressBuilderAnchor anchor(CharSequence anchor) {
        this.anchor = anchor;
        return new AddressBuilderAnchor(this);
    }

    void set(CharSequence name, Object ... values) {
        this.parameters.put(((Object)name).toString(), Parameter.create((CharSequence)((Object)name).toString(), true, values));
    }

    void setEncoded(CharSequence name, Object ... values) {
        this.parameters.put(((Object)name).toString(), Parameter.create((CharSequence)((Object)name).toString(), false, values));
    }

    public String toString() {
        return this.build().toString();
    }
}

