/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.annotation;

import com.ocpsoft.pretty.faces.annotation.URLAction;
import com.ocpsoft.pretty.faces.annotation.URLActions;
import com.ocpsoft.pretty.faces.annotation.URLBeanName;
import com.ocpsoft.pretty.faces.annotation.URLMapping;
import com.ocpsoft.pretty.faces.annotation.URLMappings;
import com.ocpsoft.pretty.faces.annotation.URLQueryParameter;
import com.ocpsoft.pretty.faces.annotation.URLValidator;
import com.ocpsoft.pretty.faces.config.PrettyConfigBuilder;
import com.ocpsoft.pretty.faces.config.mapping.PathValidator;
import com.ocpsoft.pretty.faces.config.mapping.QueryParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlAction;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.el.ConstantExpression;
import com.ocpsoft.pretty.faces.el.LazyBeanNameFinder;
import com.ocpsoft.pretty.faces.el.LazyExpression;
import com.ocpsoft.pretty.faces.el.PrettyExpression;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class PrettyAnnotationHandler {
    private static final Log log = LogFactory.getLog(PrettyAnnotationHandler.class);
    private final Map<String, UrlMapping> urlMappings = new HashMap<String, UrlMapping>();
    private final Map<Class, String> beanNameMap = new HashMap<Class, String>();
    private final List<ActionSpec> urlActions = new ArrayList<ActionSpec>();
    private final List<QueryParamSpec> queryParamList = new ArrayList<QueryParamSpec>();
    private final LazyBeanNameFinder beanNameFinder;

    public PrettyAnnotationHandler(LazyBeanNameFinder beanNameFinder) {
        this.beanNameFinder = beanNameFinder;
    }

    public void processClass(Class clazz) {
        if (log.isTraceEnabled()) {
            log.trace("Analyzing class: " + clazz.getName());
        }
        try {
            String[] classMappingIds = this.processClassMappingAnnotations(clazz);
            this.processPrettyBeanAnnotation(clazz);
            for (Method method : clazz.getMethods()) {
                this.processMethodAnnotations(method, classMappingIds);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                this.processFieldAnnotations((Field)accessibleObject, classMappingIds);
            }
        }
        catch (NoClassDefFoundError e) {
            log.debug("Unable to process class '" + clazz.getName() + "': " + e.toString());
        }
    }

    public String[] processClassMappingAnnotations(Class clazz) {
        URLMappings mappingsAnnotation;
        ArrayList<String> classMappingIds = new ArrayList<String>();
        URLMapping mappingAnnotation = clazz.getAnnotation(URLMapping.class);
        if (mappingAnnotation != null) {
            String mappingId = this.processPrettyMappingAnnotation(clazz, mappingAnnotation);
            classMappingIds.add(mappingId);
        }
        if ((mappingsAnnotation = clazz.getAnnotation(URLMappings.class)) != null) {
            for (URLMapping child : mappingsAnnotation.mappings()) {
                String mappingId = this.processPrettyMappingAnnotation(clazz, child);
                classMappingIds.add(mappingId);
            }
        }
        return classMappingIds.toArray(new String[classMappingIds.size()]);
    }

    private String processPrettyMappingAnnotation(Class clazz, URLMapping mappingAnnotation) {
        if (log.isTraceEnabled()) {
            log.trace("Found @URLMapping annotation on class: " + clazz.getName());
        }
        UrlMapping mapping = new UrlMapping();
        mapping.setId(mappingAnnotation.id());
        mapping.setParentId(mappingAnnotation.parentId());
        mapping.setPattern(mappingAnnotation.pattern());
        mapping.setViewId(mappingAnnotation.viewId());
        mapping.setOutbound(mappingAnnotation.outbound());
        mapping.setOnPostback(mappingAnnotation.onPostback());
        UrlMapping existingMapping = this.urlMappings.put(mapping.getId(), mapping);
        if (existingMapping != null) {
            throw new IllegalArgumentException("Duplicated mapping id: " + mapping.getId());
        }
        if (mappingAnnotation.beanName() != null && mappingAnnotation.beanName().length() > 0) {
            this.beanNameMap.put(clazz, mappingAnnotation.beanName());
        }
        for (URLValidator validationAnnotation : mappingAnnotation.validation()) {
            if (validationAnnotation.index() < 0) {
                throw new IllegalArgumentException("Please set the index of the path parameter you want to validate with the @URLValidator specified on mapping: " + mapping.getId());
            }
            PathValidator pathValidator = new PathValidator();
            pathValidator.setIndex(validationAnnotation.index());
            pathValidator.setOnError(validationAnnotation.onError());
            pathValidator.setValidatorIds(PrettyAnnotationHandler.join(validationAnnotation.validatorIds(), " "));
            if (!PrettyAnnotationHandler.isBlank(validationAnnotation.validator())) {
                pathValidator.setValidatorExpression(new ConstantExpression(validationAnnotation.validator()));
            }
            mapping.getPathValidators().add(pathValidator);
        }
        return mapping.getId().trim();
    }

    private void processPrettyBeanAnnotation(Class clazz) {
        URLBeanName prettyBean = clazz.getAnnotation(URLBeanName.class);
        if (prettyBean != null) {
            if (log.isTraceEnabled()) {
                log.trace("Found @URLBeanName annotation on class: " + clazz.getName());
            }
            this.beanNameMap.put(clazz, prettyBean.value());
        }
    }

    private void processMethodAnnotations(Method method, String[] classMappingIds) {
        URLActions actionsAnnotation;
        URLAction actionAnnotation = method.getAnnotation(URLAction.class);
        if (actionAnnotation != null) {
            this.processPrettyActionAnnotation(actionAnnotation, method, classMappingIds);
        }
        if ((actionsAnnotation = method.getAnnotation(URLActions.class)) != null) {
            for (URLAction child : actionsAnnotation.actions()) {
                this.processPrettyActionAnnotation(child, method, classMappingIds);
            }
        }
    }

    private void processFieldAnnotations(Field field, String[] classMappingIds) {
        URLQueryParameter queryParamAnnotation = field.getAnnotation(URLQueryParameter.class);
        if (queryParamAnnotation != null) {
            QueryParamSpec queryParam = new QueryParamSpec();
            queryParam.setFieldName(field.getName());
            queryParam.setOwnerClass(field.getDeclaringClass());
            queryParam.setName(queryParamAnnotation.value());
            queryParam.setOnPostback(queryParamAnnotation.onPostback());
            if (!PrettyAnnotationHandler.isBlank(queryParamAnnotation.mappingId())) {
                queryParam.setMappingIds(new String[]{queryParamAnnotation.mappingId().trim()});
            } else if (classMappingIds != null && classMappingIds.length > 0) {
                queryParam.setMappingIds(classMappingIds);
            } else {
                throw new IllegalArgumentException("Unable to find a suitable mapping for the query-parameter definied on field '" + field.getName() + "' in class '" + field.getDeclaringClass().getName() + "'. Either place a @URLMapping annotation on the " + "class or reference a foreign mapping using the 'mappingId' attribute.");
            }
            URLValidator validationAnnotation = field.getAnnotation(URLValidator.class);
            if (validationAnnotation != null) {
                queryParam.setValidatorIds(validationAnnotation.validatorIds());
                queryParam.setOnError(validationAnnotation.onError());
                queryParam.setValidator(validationAnnotation.validator());
            }
            this.queryParamList.add(queryParam);
        }
    }

    private void processPrettyActionAnnotation(URLAction actionAnnotation, Method method, String[] classMappingIds) {
        ActionSpec actionSpec = new ActionSpec();
        actionSpec.setMethod(method);
        actionSpec.setOnPostback(actionAnnotation.onPostback());
        actionSpec.setInheritable(actionAnnotation.inheritable());
        actionSpec.setPhaseId(actionAnnotation.phaseId());
        if (!PrettyAnnotationHandler.isBlank(actionAnnotation.mappingId())) {
            actionSpec.setMappingIds(new String[]{actionAnnotation.mappingId().trim()});
        } else if (classMappingIds != null && classMappingIds.length > 0) {
            actionSpec.setMappingIds(classMappingIds);
        } else {
            throw new IllegalArgumentException("Unable to find a suitable mapping for the action definied on method '" + method.getName() + "' in class '" + method.getDeclaringClass().getName() + "'. Either place a @URLMapping annotation on the " + "class or reference a foreign mapping using the 'mappingId' attribute.");
        }
        this.urlActions.add(actionSpec);
    }

    private static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public void build(PrettyConfigBuilder builder) {
        PrettyExpression expression;
        Class<?> clazz;
        UrlMapping mapping;
        for (ActionSpec actionSpec : this.urlActions) {
            for (String mappingId : actionSpec.getMappingIds()) {
                mapping = this.urlMappings.get(mappingId);
                if (mapping == null) {
                    throw new IllegalArgumentException("Unable to find the mapping '" + mappingId + "' referenced at method '" + actionSpec.getMethod().getName() + "' in class '" + actionSpec.getMethod().getDeclaringClass().getName() + "'.");
                }
                UrlAction urlAction = new UrlAction();
                urlAction.setPhaseId(actionSpec.getPhaseId());
                urlAction.setOnPostback(actionSpec.isOnPostback());
                urlAction.setInheritable(actionSpec.isInheritable());
                clazz = actionSpec.getMethod().getDeclaringClass();
                expression = this.buildPrettyExpression(clazz, actionSpec.getMethod().getName());
                urlAction.setAction(expression);
                if (log.isTraceEnabled()) {
                    log.trace("Adding action expression '" + urlAction.getAction() + "' to mapping: " + mapping.getId());
                }
                mapping.addAction(urlAction);
            }
        }
        for (QueryParamSpec queryParamSpec : this.queryParamList) {
            for (String mappingId : queryParamSpec.getMappingIds()) {
                mapping = this.urlMappings.get(mappingId);
                if (mapping == null) {
                    throw new IllegalArgumentException("Unable to find the mapping '" + mappingId + "' referenced at field '" + queryParamSpec.getFieldName() + "' in class '" + queryParamSpec.getOwnerClass().getName() + "'.");
                }
                QueryParameter queryParam = new QueryParameter();
                queryParam.setName(queryParamSpec.getName());
                queryParam.setOnError(queryParamSpec.getOnError());
                queryParam.setValidatorIds(PrettyAnnotationHandler.join(queryParamSpec.getValidatorIds(), " "));
                queryParam.setOnPostback(queryParamSpec.isOnPostback());
                if (!PrettyAnnotationHandler.isBlank(queryParamSpec.getValidator())) {
                    queryParam.setValidatorExpression(new ConstantExpression(queryParamSpec.getValidator()));
                }
                clazz = queryParamSpec.getOwnerClass();
                expression = this.buildPrettyExpression(clazz, queryParamSpec.getFieldName());
                queryParam.setExpression(expression);
                if (log.isTraceEnabled()) {
                    log.trace("Registered query-param '" + queryParam.getName() + "' to '" + expression + "' in mapping: " + mapping.getId());
                }
                mapping.addQueryParam(queryParam);
            }
        }
        for (UrlMapping mapping2 : this.urlMappings.values()) {
            builder.addMapping(mapping2);
        }
    }

    private PrettyExpression buildPrettyExpression(Class<?> clazz, String component) {
        String beanName;
        if (log.isTraceEnabled()) {
            log.trace("Searching name of bean: " + clazz.getName());
        }
        if ((beanName = this.beanNameMap.get(clazz)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("Got bean name from @URLBeanName annotation: " + beanName);
            }
            return new ConstantExpression("#{" + beanName + "." + component + "}");
        }
        if (log.isTraceEnabled()) {
            log.trace("Name of bean not found. Building lazy expression for: " + clazz.getName());
        }
        return new LazyExpression(this.beanNameFinder, clazz, component);
    }

    private static String join(String[] values, String separator) {
        StringBuilder result = new StringBuilder();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    result.append(separator);
                }
                result.append(values[i]);
            }
        }
        return result.toString();
    }

    private static class QueryParamSpec {
        private String fieldName;
        private Class<?> ownerClass;
        private String[] mappingIds;
        private String name;
        private String onError;
        private String[] validatorIds = new String[0];
        private String validator;
        private boolean onPostback;

        private QueryParamSpec() {
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public Class<?> getOwnerClass() {
            return this.ownerClass;
        }

        public void setOwnerClass(Class<?> ownerClass) {
            this.ownerClass = ownerClass;
        }

        public String getOnError() {
            return this.onError;
        }

        public void setOnError(String onError) {
            this.onError = onError;
        }

        public String[] getValidatorIds() {
            return this.validatorIds;
        }

        public void setValidatorIds(String[] validatorIds) {
            this.validatorIds = validatorIds;
        }

        public boolean isOnPostback() {
            return this.onPostback;
        }

        public void setOnPostback(boolean onPostback) {
            this.onPostback = onPostback;
        }

        public String[] getMappingIds() {
            return this.mappingIds;
        }

        public void setMappingIds(String[] mappingIds) {
            this.mappingIds = mappingIds;
        }
    }

    private static class ActionSpec {
        private Method method;
        private boolean onPostback;
        private URLAction.PhaseId phaseId;
        private String[] mappingIds;
        private boolean inheritable;

        private ActionSpec() {
        }

        public boolean isOnPostback() {
            return this.onPostback;
        }

        public void setOnPostback(boolean onPostback) {
            this.onPostback = onPostback;
        }

        public URLAction.PhaseId getPhaseId() {
            return this.phaseId;
        }

        public void setPhaseId(URLAction.PhaseId phaseId) {
            this.phaseId = phaseId;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public String[] getMappingIds() {
            return this.mappingIds;
        }

        public void setMappingIds(String[] mappingIds) {
            this.mappingIds = mappingIds;
        }

        public boolean isInheritable() {
            return this.inheritable;
        }

        public void setInheritable(boolean inheritable) {
            this.inheritable = inheritable;
        }
    }
}

