/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.Set;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternBuilder;

public class Log
extends DefaultOperationBuilder
implements Parameterized {
    private static final Logger log = Logger.getLogger(Log.class);
    private Logger.Level level;
    private RegexParameterizedPatternBuilder messageBuilder;

    private Log(Logger.Level level, String message) {
        this.level = level;
        this.messageBuilder = new RegexParameterizedPatternBuilder(message);
    }

    public static Log message(Logger.Level level, String message) {
        return new Log(level, message);
    }

    @Override
    public void perform(Rewrite event, EvaluationContext context) {
        String message = this.messageBuilder.build(event, context);
        switch (this.level) {
            case TRACE: {
                if (!log.isTraceEnabled()) break;
                log.trace(message);
                break;
            }
            case DEBUG: {
                if (!log.isDebugEnabled()) break;
                log.debug(message);
                break;
            }
            case INFO: {
                if (!log.isInfoEnabled()) break;
                log.info(message);
                break;
            }
            case WARN: {
                if (!log.isWarnEnabled()) break;
                log.warn(message);
                break;
            }
            case ERROR: {
                if (!log.isErrorEnabled()) break;
                log.error(message);
                break;
            }
        }
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        return this.messageBuilder.getRequiredParameterNames();
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        this.messageBuilder.setParameterStore(store);
    }
}

