/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.param.DefaultParameter;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.util.ValueHolderUtil;

public class ParameterUtils {
    public static void initialize(ParameterStore store, Parameterized parameterized) {
        Set<String> names = parameterized.getRequiredParameterNames();
        for (String name : names) {
            store.get(name, new DefaultParameter(name));
        }
        parameterized.setParameterStore(store);
    }

    public static boolean enqueueSubmission(Rewrite event, EvaluationContext context, Parameter<?> parameter, Object value) {
        if (value == null) {
            return true;
        }
        ArrayList<BindingOperation> operations = new ArrayList<BindingOperation>();
        List<Binding> bindings = parameter.getBindings();
        for (Binding binding : bindings) {
            try {
                Object convertedValue;
                if (binding instanceof Evaluation) {
                    convertedValue = ValueHolderUtil.convert(event, context, parameter.getConverter(), value);
                    if (ValueHolderUtil.validates(event, context, parameter.getValidator(), convertedValue)) {
                        Evaluation evaluation = (Evaluation)binding;
                        evaluation.submit(event, context, value);
                        evaluation.submitConverted(event, context, convertedValue);
                        continue;
                    }
                    return false;
                }
                convertedValue = ValueHolderUtil.convert(event, context, parameter.getConverter(), value);
                if (ValueHolderUtil.validates(event, context, parameter.getValidator(), convertedValue)) {
                    operations.add(new BindingOperation(binding, convertedValue));
                    continue;
                }
                return false;
            }
            catch (Exception e) {
                throw new RewriteException("Failed to bind value [" + value + "] to binding [" + binding + "]", e);
            }
        }
        for (Operation operation : operations) {
            context.addPreOperation(operation);
        }
        return true;
    }

    public static Object performRetrieval(Rewrite event, EvaluationContext context, Parameter<?> parameter) {
        Object result = null;
        ArrayList<Binding> bindings = new ArrayList<Binding>(parameter.getBindings());
        Collections.reverse(bindings);
        for (Binding binding : bindings) {
            if (result != null || binding instanceof Evaluation) continue;
            result = binding.retrieve(event, context);
        }
        for (Binding binding : bindings) {
            if (!(binding instanceof Evaluation) || !((Evaluation)binding).hasValue(event, context)) continue;
            result = binding.retrieve(event, context);
        }
        return result;
    }

    private static class BindingOperation
    implements Operation {
        private final Binding binding;
        private final Object value;

        public BindingOperation(Binding binding, Object value) {
            this.binding = binding;
            this.value = value;
        }

        @Override
        public void perform(Rewrite event, EvaluationContext context) {
            this.binding.submit(event, context, this.value);
        }

        public String toString() {
            return "BindingOperation [binding=" + this.binding + ", value=" + this.value + "]";
        }
    }
}

