/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class Filesystem
implements Condition,
Parameterized {
    private final ParameterizedPatternParser resource;
    private final FileFilter filter;

    private Filesystem(File resource, FileFilter filter) {
        Assert.notNull(resource, "File path to inspect must not be null.");
        Assert.notNull(filter, "FileFilter must not be null.");
        this.resource = new RegexParameterizedPatternParser(resource.getAbsolutePath());
        this.filter = filter;
    }

    @Override
    public boolean evaluate(Rewrite event, EvaluationContext context) {
        ParameterizedPatternBuilder builder;
        if (this.resource != null && (builder = this.resource.getBuilder()).isParameterComplete(event, context)) {
            String filePath = builder.build(event, context);
            File file = new File(filePath);
            return this.filter.accept(file);
        }
        return false;
    }

    public static Filesystem fileExists(File resource) {
        return new Filesystem(resource, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.exists() && file.isFile();
            }
        });
    }

    public static Filesystem directoryExists(File resource) {
        return new Filesystem(resource, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.exists() && file.isDirectory();
            }
        });
    }

    public ParameterizedPatternParser getExpression() {
        return this.resource;
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        return this.resource.getRequiredParameterNames();
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        this.resource.setParameterStore(store);
    }
}

