/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.Transposition;

public class DefaultParameterValueStore
implements ParameterValueStore,
Iterable<Map.Entry<Parameter<?>, String>> {
    Map<Parameter<?>, String> map = new LinkedHashMap();

    @Override
    public String retrieve(Parameter<?> parameter) {
        return this.map.get(parameter);
    }

    @Override
    public boolean submit(Rewrite event, EvaluationContext context, Parameter<?> param, String value) {
        boolean result = false;
        String stored = this.map.get(param);
        if ("*".equals(param.getName())) {
            result = true;
        } else if (stored == value || stored != null && stored.equals(value)) {
            result = true;
        } else if (stored == null) {
            result = true;
            for (Constraint<String> constraint : param.getConstraints()) {
                if (constraint.isSatisfiedBy(event, context, value)) continue;
                result = false;
            }
            if (result) {
                for (Transposition transposition : param.getTranspositions()) {
                    value = transposition.transpose(event, context, value);
                }
                this.map.put(param, value);
                result = true;
            }
        }
        return result;
    }

    public String get(Parameter<?> parameter) {
        return this.map.get(parameter);
    }

    @Override
    public Iterator<Map.Entry<Parameter<?>, String>> iterator() {
        return this.map.entrySet().iterator();
    }

    public String toString() {
        return this.map.keySet().toString();
    }
}

