/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.faces.event.PhaseId;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.pattern.Weighted;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class PhaseOperation<T extends PhaseOperation<T>>
extends HttpOperation
implements Weighted {
    private static final String REQUEST_KEY = PhaseOperation.class.getName() + "_DEFERRED";
    private final Set<PhaseId> beforePhases = new HashSet<PhaseId>();
    private final Set<PhaseId> afterPhases = new HashSet<PhaseId>();

    public abstract void performOperation(HttpServletRewrite var1, EvaluationContext var2);

    public static PhaseOperation<?> enqueue(Operation operation) {
        return PhaseOperation.enqueue(operation, 0);
    }

    public static PhaseOperation<?> enqueue(final Operation operation, final int priority) {
        return new PhaseOperation(){

            public int priority() {
                return priority;
            }

            @Override
            public void performOperation(HttpServletRewrite event, EvaluationContext context) {
                operation.perform((Rewrite)event, context);
            }
        };
    }

    public Set<PhaseId> getBeforePhases() {
        return this.beforePhases;
    }

    public Set<PhaseId> getAfterPhases() {
        return this.afterPhases;
    }

    public T before(PhaseId ... phases) {
        if (phases != null) {
            this.beforePhases.addAll(Arrays.asList(phases));
        }
        return (T)((Object)this);
    }

    public T after(PhaseId ... phases) {
        if (phases != null) {
            this.afterPhases.addAll(Arrays.asList(phases));
        }
        return (T)((Object)this);
    }

    public final void performHttp(HttpServletRewrite event, EvaluationContext context) {
        PhaseOperation.getSortedPhaseOperations((HttpServletRequest)event.getRequest()).add(new DeferredOperation(event, context, this));
    }

    public static ArrayList<DeferredOperation> getSortedPhaseOperations(HttpServletRequest request) {
        ArrayList<DeferredOperation> operations = (ArrayList<DeferredOperation>)request.getAttribute(REQUEST_KEY);
        if (operations == null) {
            operations = new ArrayList<DeferredOperation>();
            request.setAttribute(REQUEST_KEY, operations);
        }
        Collections.sort(operations, new WeightedComparator());
        return operations;
    }

    public static class DeferredOperation
    implements Weighted {
        private final HttpServletRewrite event;
        private final EvaluationContext context;
        private final PhaseOperation<?> operation;

        public DeferredOperation(HttpServletRewrite event, EvaluationContext context, PhaseOperation<?> operation) {
            this.event = event;
            this.context = context;
            this.operation = operation;
        }

        public int priority() {
            return this.operation.priority();
        }

        public HttpServletRewrite getEvent() {
            return this.event;
        }

        public EvaluationContext getContext() {
            return this.context;
        }

        public PhaseOperation<?> getOperation() {
            return this.operation;
        }
    }
}

