/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.url;

import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Segment {
    private static final String SUFFIX = "#-p#";
    private static final String PREFIX = "#p-#";
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("#p-#(\\d+)#-p#");
    private String template;
    private String regex;
    private final List<PathParameter> parameters = new ArrayList<PathParameter>();

    public static String parameterize(int paramIndex) {
        return PREFIX + paramIndex + SUFFIX;
    }

    public static Matcher getTemplateMatcher(String target) {
        return TEMPLATE_PATTERN.matcher(target);
    }

    public Matcher getMatcher(String target) {
        return Pattern.compile(this.regex).matcher(target);
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void addParameter(PathParameter parameter) {
        this.parameters.add(parameter);
    }

    public PathParameter getParameter(int index) {
        return this.parameters.get(index);
    }

    public List<PathParameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public int numParameters() {
        return this.parameters.size();
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String pattern) {
        this.template = pattern;
    }

    public String toString() {
        return "Segment [template=" + this.template + ", regex=" + this.regex + "]";
    }
}

