/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.spi;

import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.PrettyConfigBuilder;
import com.ocpsoft.pretty.faces.config.annotation.AbstractClassFinder;
import com.ocpsoft.pretty.faces.config.annotation.ClassFinder;
import com.ocpsoft.pretty.faces.config.annotation.PackageFilter;
import com.ocpsoft.pretty.faces.config.annotation.PrettyAnnotationHandler;
import com.ocpsoft.pretty.faces.config.annotation.WebClassesFinder;
import com.ocpsoft.pretty.faces.config.annotation.WebLibFinder;
import com.ocpsoft.pretty.faces.el.LazyBeanNameFinder;
import com.ocpsoft.pretty.faces.spi.ConfigurationProvider;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class AnnotationConfigurationProvider
implements ConfigurationProvider {
    private static final Log log = LogFactory.getLog(AnnotationConfigurationProvider.class);
    public static final String CONFIG_SCAN_LIB_DIR = "com.ocpsoft.pretty.SCAN_LIB_DIRECTORY";
    public static final String CONFIG_BASE_PACKAGES = "com.ocpsoft.pretty.BASE_PACKAGES";

    @Override
    public PrettyConfig loadConfiguration(ServletContext servletContext) {
        String packageFilters = servletContext.getInitParameter(CONFIG_BASE_PACKAGES);
        if (packageFilters != null && packageFilters.trim().equalsIgnoreCase("none")) {
            log.debug("Annotation scanning has is disabled!");
            return null;
        }
        PackageFilter packageFilter = new PackageFilter(packageFilters);
        LazyBeanNameFinder beanNameFinder = new LazyBeanNameFinder(servletContext);
        PrettyAnnotationHandler annotationHandler = new PrettyAnnotationHandler(beanNameFinder);
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (classloader == null) {
            classloader = this.getClass().getClassLoader();
        }
        ArrayList<AbstractClassFinder> classFinders = new ArrayList<AbstractClassFinder>();
        classFinders.add(new WebClassesFinder(servletContext, classloader, packageFilter));
        String jarConfig = servletContext.getInitParameter(CONFIG_SCAN_LIB_DIR);
        if (jarConfig != null && jarConfig.trim().equalsIgnoreCase("true")) {
            classFinders.add(new WebLibFinder(servletContext, classloader, packageFilter));
        }
        for (ClassFinder classFinder : classFinders) {
            classFinder.findClasses(annotationHandler);
        }
        PrettyConfigBuilder builder = new PrettyConfigBuilder();
        annotationHandler.build(builder);
        return builder.build();
    }
}

