/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.prettyfaces;

import com.ocpsoft.pretty.faces.config.rewrite.Redirect;
import com.ocpsoft.pretty.faces.config.rewrite.RewriteRule;
import com.ocpsoft.pretty.faces.rewrite.RewriteEngine;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.util.StringUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.prettyfaces.PFUtil;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;

public class InboundRewriteRuleAdaptor
implements Rule {
    private final RewriteRule rule;

    public InboundRewriteRuleAdaptor(RewriteRule rule) {
        this.rule = rule;
    }

    public String getId() {
        return this.toString();
    }

    public boolean evaluate(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite && this.rule.isInbound() && PFUtil.isRewritingEnabled(event)) {
            HttpServletRewrite httpRewrite = (HttpServletRewrite)event;
            String path = httpRewrite.getInboundAddress().getPath();
            String url = URL.build(path).decode().toURL() + QueryString.build(httpRewrite.getInboundAddress().getQuery()).toQueryString();
            if (url.startsWith(httpRewrite.getContextPath())) {
                url = url.substring(httpRewrite.getContextPath().length());
            }
            if (this.rule.matches(url)) {
                return true;
            }
        }
        return false;
    }

    public void perform(Rewrite event, EvaluationContext context) {
        RewriteEngine engine = new RewriteEngine();
        HttpServletRewrite httpRewrite = (HttpServletRewrite)event;
        String originalUrl = httpRewrite.getInboundAddress().getPath();
        if ((originalUrl = URL.build(originalUrl).decode().toURL() + QueryString.build(httpRewrite.getInboundAddress().getQuery()).toQueryString()).startsWith(((HttpServletRewrite)event).getContextPath())) {
            originalUrl = originalUrl.substring(((HttpServletRewrite)event).getContextPath().length());
        }
        String newUrl = engine.processInbound((HttpServletRequest)((HttpServletRewrite)event).getRequest(), (HttpServletResponse)((HttpServletRewrite)event).getResponse(), this.rule, originalUrl);
        if (!Redirect.CHAIN.equals((Object)this.rule.getRedirect())) {
            String redirectURL = null;
            if (StringUtils.isBlank(this.rule.getUrl()) && !originalUrl.equals(newUrl)) {
                redirectURL = ((HttpServletRewrite)event).getContextPath() + newUrl;
            } else if (StringUtils.isNotBlank(this.rule.getUrl())) {
                redirectURL = newUrl.trim();
            }
            if (redirectURL != null) {
                URLBuilder encodedRedirectUrl = URLBuilder.createFrom((String)redirectURL).encode();
                redirectURL = encodedRedirectUrl.toString();
                if (Redirect.PERMANENT.equals((Object)this.rule.getRedirect())) {
                    ((HttpInboundServletRewrite)event).redirectPermanent(redirectURL);
                }
                if (Redirect.TEMPORARY.equals((Object)this.rule.getRedirect())) {
                    ((HttpInboundServletRewrite)event).redirectTemporary(redirectURL);
                }
            }
        } else if (!originalUrl.equals(newUrl)) {
            PFUtil.setRewriteOccurred(event);
            ((HttpInboundServletRewrite)event).forward(newUrl);
        }
    }

    public String toString() {
        return "InboundRewriteRuleAdaptor [rule=" + this.rule + "]";
    }
}

